/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.OccurrenceDayRequestSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduledInstanceRecurrenceRequest
implements ToCopyableBuilder<Builder, ScheduledInstanceRecurrenceRequest> {
    private final String frequency;
    private final Integer interval;
    private final List<Integer> occurrenceDays;
    private final Boolean occurrenceRelativeToEnd;
    private final String occurrenceUnit;

    private ScheduledInstanceRecurrenceRequest(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.interval = builder.interval;
        this.occurrenceDays = builder.occurrenceDays;
        this.occurrenceRelativeToEnd = builder.occurrenceRelativeToEnd;
        this.occurrenceUnit = builder.occurrenceUnit;
    }

    public String frequency() {
        return this.frequency;
    }

    public Integer interval() {
        return this.interval;
    }

    public List<Integer> occurrenceDays() {
        return this.occurrenceDays;
    }

    public Boolean occurrenceRelativeToEnd() {
        return this.occurrenceRelativeToEnd;
    }

    public String occurrenceUnit() {
        return this.occurrenceUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrenceDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrenceRelativeToEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.occurrenceUnit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceRecurrenceRequest)) {
            return false;
        }
        ScheduledInstanceRecurrenceRequest other = (ScheduledInstanceRecurrenceRequest)obj;
        return Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.occurrenceDays(), other.occurrenceDays()) && Objects.equals(this.occurrenceRelativeToEnd(), other.occurrenceRelativeToEnd()) && Objects.equals(this.occurrenceUnit(), other.occurrenceUnit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.frequency() != null) {
            sb.append("Frequency: ").append(this.frequency()).append(",");
        }
        if (this.interval() != null) {
            sb.append("Interval: ").append(this.interval()).append(",");
        }
        if (this.occurrenceDays() != null) {
            sb.append("OccurrenceDays: ").append(this.occurrenceDays()).append(",");
        }
        if (this.occurrenceRelativeToEnd() != null) {
            sb.append("OccurrenceRelativeToEnd: ").append(this.occurrenceRelativeToEnd()).append(",");
        }
        if (this.occurrenceUnit() != null) {
            sb.append("OccurrenceUnit: ").append(this.occurrenceUnit()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Frequency": {
                return Optional.of(clazz.cast(this.frequency()));
            }
            case "Interval": {
                return Optional.of(clazz.cast(this.interval()));
            }
            case "OccurrenceDays": {
                return Optional.of(clazz.cast(this.occurrenceDays()));
            }
            case "OccurrenceRelativeToEnd": {
                return Optional.of(clazz.cast(this.occurrenceRelativeToEnd()));
            }
            case "OccurrenceUnit": {
                return Optional.of(clazz.cast(this.occurrenceUnit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String frequency;
        private Integer interval;
        private List<Integer> occurrenceDays;
        private Boolean occurrenceRelativeToEnd;
        private String occurrenceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceRecurrenceRequest model) {
            this.frequency(model.frequency);
            this.interval(model.interval);
            this.occurrenceDays(model.occurrenceDays);
            this.occurrenceRelativeToEnd(model.occurrenceRelativeToEnd);
            this.occurrenceUnit(model.occurrenceUnit);
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final Collection<Integer> getOccurrenceDays() {
            return this.occurrenceDays;
        }

        @Override
        public final Builder occurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder occurrenceDays(Integer ... occurrenceDays) {
            this.occurrenceDays(Arrays.asList(occurrenceDays));
            return this;
        }

        public final void setOccurrenceDays(Collection<Integer> occurrenceDays) {
            this.occurrenceDays = OccurrenceDayRequestSetCopier.copy(occurrenceDays);
        }

        public final Boolean getOccurrenceRelativeToEnd() {
            return this.occurrenceRelativeToEnd;
        }

        @Override
        public final Builder occurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
            return this;
        }

        public final void setOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
            this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
        }

        public final String getOccurrenceUnit() {
            return this.occurrenceUnit;
        }

        @Override
        public final Builder occurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
            return this;
        }

        public final void setOccurrenceUnit(String occurrenceUnit) {
            this.occurrenceUnit = occurrenceUnit;
        }

        public ScheduledInstanceRecurrenceRequest build() {
            return new ScheduledInstanceRecurrenceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledInstanceRecurrenceRequest> {
        public Builder frequency(String var1);

        public Builder interval(Integer var1);

        public Builder occurrenceDays(Collection<Integer> var1);

        public Builder occurrenceDays(Integer ... var1);

        public Builder occurrenceRelativeToEnd(Boolean var1);

        public Builder occurrenceUnit(String var1);
    }
}

