/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.InstanceIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RunScheduledInstancesResponse
extends EC2Response
implements ToCopyableBuilder<Builder, RunScheduledInstancesResponse> {
    private final List<String> instanceIdSet;

    private RunScheduledInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceIdSet = builder.instanceIdSet;
    }

    public List<String> instanceIdSet() {
        return this.instanceIdSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIdSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesResponse)) {
            return false;
        }
        RunScheduledInstancesResponse other = (RunScheduledInstancesResponse)((Object)obj);
        return Objects.equals(this.instanceIdSet(), other.instanceIdSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceIdSet() != null) {
            sb.append("InstanceIdSet: ").append(this.instanceIdSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIdSet": {
                return Optional.of(clazz.cast(this.instanceIdSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<String> instanceIdSet;

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesResponse model) {
            this.instanceIdSet(model.instanceIdSet);
        }

        public final Collection<String> getInstanceIdSet() {
            return this.instanceIdSet;
        }

        @Override
        public final Builder instanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIdSet(String ... instanceIdSet) {
            this.instanceIdSet(Arrays.asList(instanceIdSet));
            return this;
        }

        public final void setInstanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
        }

        @Override
        public RunScheduledInstancesResponse build() {
            return new RunScheduledInstancesResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, RunScheduledInstancesResponse> {
        public Builder instanceIdSet(Collection<String> var1);

        public Builder instanceIdSet(String ... var1);
    }
}

