/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.InstanceMonitoring;
import software.amazon.awssdk.services.ec2.model.InstanceMonitoringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MonitorInstancesResponse
extends EC2Response
implements ToCopyableBuilder<Builder, MonitorInstancesResponse> {
    private final List<InstanceMonitoring> instanceMonitorings;

    private MonitorInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceMonitorings = builder.instanceMonitorings;
    }

    public List<InstanceMonitoring> instanceMonitorings() {
        return this.instanceMonitorings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMonitorings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorInstancesResponse)) {
            return false;
        }
        MonitorInstancesResponse other = (MonitorInstancesResponse)((Object)obj);
        return Objects.equals(this.instanceMonitorings(), other.instanceMonitorings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceMonitorings() != null) {
            sb.append("InstanceMonitorings: ").append(this.instanceMonitorings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceMonitorings": {
                return Optional.of(clazz.cast(this.instanceMonitorings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<InstanceMonitoring> instanceMonitorings;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorInstancesResponse model) {
            this.instanceMonitorings(model.instanceMonitorings);
        }

        public final Collection<InstanceMonitoring.Builder> getInstanceMonitorings() {
            return this.instanceMonitorings != null ? (Collection)this.instanceMonitorings.stream().map(InstanceMonitoring::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copy(instanceMonitorings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(InstanceMonitoring ... instanceMonitorings) {
            this.instanceMonitorings(Arrays.asList(instanceMonitorings));
            return this;
        }

        public final void setInstanceMonitorings(Collection<InstanceMonitoring.BuilderImpl> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copyFromBuilder(instanceMonitorings);
        }

        @Override
        public MonitorInstancesResponse build() {
            return new MonitorInstancesResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, MonitorInstancesResponse> {
        public Builder instanceMonitorings(Collection<InstanceMonitoring> var1);

        public Builder instanceMonitorings(InstanceMonitoring ... var1);
    }
}

