/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IamInstanceProfile
implements ToCopyableBuilder<Builder, IamInstanceProfile> {
    private final String arn;
    private final String id;

    private IamInstanceProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
    }

    public String arn() {
        return this.arn;
    }

    public String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamInstanceProfile)) {
            return false;
        }
        IamInstanceProfile other = (IamInstanceProfile)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(IamInstanceProfile model) {
            this.arn(model.arn);
            this.id(model.id);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public IamInstanceProfile build() {
            return new IamInstanceProfile(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IamInstanceProfile> {
        public Builder arn(String var1);

        public Builder id(String var1);
    }
}

