/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachmentListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EgressOnlyInternetGateway
implements ToCopyableBuilder<Builder, EgressOnlyInternetGateway> {
    private final List<InternetGatewayAttachment> attachments;
    private final String egressOnlyInternetGatewayId;

    private EgressOnlyInternetGateway(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
    }

    public List<InternetGatewayAttachment> attachments() {
        return this.attachments;
    }

    public String egressOnlyInternetGatewayId() {
        return this.egressOnlyInternetGatewayId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGatewayId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressOnlyInternetGateway)) {
            return false;
        }
        EgressOnlyInternetGateway other = (EgressOnlyInternetGateway)obj;
        return Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attachments() != null) {
            sb.append("Attachments: ").append(this.attachments()).append(",");
        }
        if (this.egressOnlyInternetGatewayId() != null) {
            sb.append("EgressOnlyInternetGatewayId: ").append(this.egressOnlyInternetGatewayId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachments": {
                return Optional.of(clazz.cast(this.attachments()));
            }
            case "EgressOnlyInternetGatewayId": {
                return Optional.of(clazz.cast(this.egressOnlyInternetGatewayId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InternetGatewayAttachment> attachments;
        private String egressOnlyInternetGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(EgressOnlyInternetGateway model) {
            this.attachments(model.attachments);
            this.egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
        }

        public final Collection<InternetGatewayAttachment.Builder> getAttachments() {
            return this.attachments != null ? (Collection)this.attachments.stream().map(InternetGatewayAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(InternetGatewayAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        public final void setAttachments(Collection<InternetGatewayAttachment.BuilderImpl> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copyFromBuilder(attachments);
        }

        public final String getEgressOnlyInternetGatewayId() {
            return this.egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public EgressOnlyInternetGateway build() {
            return new EgressOnlyInternetGateway(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EgressOnlyInternetGateway> {
        public Builder attachments(Collection<InternetGatewayAttachment> var1);

        public Builder attachments(InternetGatewayAttachment ... var1);

        public Builder egressOnlyInternetGatewayId(String var1);
    }
}

