/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceIdRequestSetCopier;
import software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledInstancesRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeScheduledInstancesRequest> {
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> scheduledInstanceIds;
    private final SlotStartTimeRangeRequest slotStartTimeRange;

    private DescribeScheduledInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scheduledInstanceIds = builder.scheduledInstanceIds;
        this.slotStartTimeRange = builder.slotStartTimeRange;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> scheduledInstanceIds() {
        return this.scheduledInstanceIds;
    }

    public SlotStartTimeRangeRequest slotStartTimeRange() {
        return this.slotStartTimeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledInstanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotStartTimeRange());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesRequest)) {
            return false;
        }
        DescribeScheduledInstancesRequest other = (DescribeScheduledInstancesRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.scheduledInstanceIds(), other.scheduledInstanceIds()) && Objects.equals(this.slotStartTimeRange(), other.slotStartTimeRange());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.scheduledInstanceIds() != null) {
            sb.append("ScheduledInstanceIds: ").append(this.scheduledInstanceIds()).append(",");
        }
        if (this.slotStartTimeRange() != null) {
            sb.append("SlotStartTimeRange: ").append(this.slotStartTimeRange()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ScheduledInstanceIds": {
                return Optional.of(clazz.cast(this.scheduledInstanceIds()));
            }
            case "SlotStartTimeRange": {
                return Optional.of(clazz.cast(this.slotStartTimeRange()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private Integer maxResults;
        private String nextToken;
        private List<String> scheduledInstanceIds;
        private SlotStartTimeRangeRequest slotStartTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstancesRequest model) {
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.scheduledInstanceIds(model.scheduledInstanceIds);
            this.slotStartTimeRange(model.slotStartTimeRange);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getScheduledInstanceIds() {
            return this.scheduledInstanceIds;
        }

        @Override
        public final Builder scheduledInstanceIds(Collection<String> scheduledInstanceIds) {
            this.scheduledInstanceIds = ScheduledInstanceIdRequestSetCopier.copy(scheduledInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceIds(String ... scheduledInstanceIds) {
            this.scheduledInstanceIds(Arrays.asList(scheduledInstanceIds));
            return this;
        }

        public final void setScheduledInstanceIds(Collection<String> scheduledInstanceIds) {
            this.scheduledInstanceIds = ScheduledInstanceIdRequestSetCopier.copy(scheduledInstanceIds);
        }

        public final SlotStartTimeRangeRequest.Builder getSlotStartTimeRange() {
            return this.slotStartTimeRange != null ? this.slotStartTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder slotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
            this.slotStartTimeRange = slotStartTimeRange;
            return this;
        }

        public final void setSlotStartTimeRange(SlotStartTimeRangeRequest.BuilderImpl slotStartTimeRange) {
            this.slotStartTimeRange = slotStartTimeRange != null ? slotStartTimeRange.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledInstancesRequest build() {
            return new DescribeScheduledInstancesRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeScheduledInstancesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder scheduledInstanceIds(Collection<String> var1);

        public Builder scheduledInstanceIds(String ... var1);

        public Builder slotStartTimeRange(SlotStartTimeRangeRequest var1);

        default public Builder slotStartTimeRange(Consumer<SlotStartTimeRangeRequest.Builder> slotStartTimeRange) {
            return this.slotStartTimeRange((SlotStartTimeRangeRequest)((SlotStartTimeRangeRequest.Builder)SlotStartTimeRangeRequest.builder().apply(slotStartTimeRange)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

