/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesModificationsRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeReservedInstancesModificationsRequest> {
    private final List<Filter> filters;
    private final List<String> reservedInstancesModificationIds;
    private final String nextToken;

    private DescribeReservedInstancesModificationsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.reservedInstancesModificationIds = builder.reservedInstancesModificationIds;
        this.nextToken = builder.nextToken;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> reservedInstancesModificationIds() {
        return this.reservedInstancesModificationIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesModificationIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesModificationsRequest)) {
            return false;
        }
        DescribeReservedInstancesModificationsRequest other = (DescribeReservedInstancesModificationsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.reservedInstancesModificationIds(), other.reservedInstancesModificationIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.reservedInstancesModificationIds() != null) {
            sb.append("ReservedInstancesModificationIds: ").append(this.reservedInstancesModificationIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "ReservedInstancesModificationIds": {
                return Optional.of(clazz.cast(this.reservedInstancesModificationIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> reservedInstancesModificationIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesModificationsRequest model) {
            this.filters(model.filters);
            this.reservedInstancesModificationIds(model.reservedInstancesModificationIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getReservedInstancesModificationIds() {
            return this.reservedInstancesModificationIds;
        }

        @Override
        public final Builder reservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds = ReservedInstancesModificationIdStringListCopier.copy(reservedInstancesModificationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesModificationIds(String ... reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds(Arrays.asList(reservedInstancesModificationIds));
            return this;
        }

        public final void setReservedInstancesModificationIds(Collection<String> reservedInstancesModificationIds) {
            this.reservedInstancesModificationIds = ReservedInstancesModificationIdStringListCopier.copy(reservedInstancesModificationIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesModificationsRequest build() {
            return new DescribeReservedInstancesModificationsRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeReservedInstancesModificationsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder reservedInstancesModificationIds(Collection<String> var1);

        public Builder reservedInstancesModificationIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

