/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.NetworkAcl;
import software.amazon.awssdk.services.ec2.model.NetworkAclListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNetworkAclsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeNetworkAclsResponse> {
    private final List<NetworkAcl> networkAcls;

    private DescribeNetworkAclsResponse(BuilderImpl builder) {
        super(builder);
        this.networkAcls = builder.networkAcls;
    }

    public List<NetworkAcl> networkAcls() {
        return this.networkAcls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAcls());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkAclsResponse)) {
            return false;
        }
        DescribeNetworkAclsResponse other = (DescribeNetworkAclsResponse)((Object)obj);
        return Objects.equals(this.networkAcls(), other.networkAcls());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.networkAcls() != null) {
            sb.append("NetworkAcls: ").append(this.networkAcls()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkAcls": {
                return Optional.of(clazz.cast(this.networkAcls()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<NetworkAcl> networkAcls;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkAclsResponse model) {
            this.networkAcls(model.networkAcls);
        }

        public final Collection<NetworkAcl.Builder> getNetworkAcls() {
            return this.networkAcls != null ? (Collection)this.networkAcls.stream().map(NetworkAcl::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkAcls(Collection<NetworkAcl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copy(networkAcls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAcls(NetworkAcl ... networkAcls) {
            this.networkAcls(Arrays.asList(networkAcls));
            return this;
        }

        public final void setNetworkAcls(Collection<NetworkAcl.BuilderImpl> networkAcls) {
            this.networkAcls = NetworkAclListCopier.copyFromBuilder(networkAcls);
        }

        @Override
        public DescribeNetworkAclsResponse build() {
            return new DescribeNetworkAclsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeNetworkAclsResponse> {
        public Builder networkAcls(Collection<NetworkAcl> var1);

        public Builder networkAcls(NetworkAcl ... var1);
    }
}

