/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostReservationOfferingsRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeHostReservationOfferingsRequest> {
    private final List<Filter> filter;
    private final Integer maxDuration;
    private final Integer maxResults;
    private final Integer minDuration;
    private final String nextToken;
    private final String offeringId;

    private DescribeHostReservationOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxDuration = builder.maxDuration;
        this.maxResults = builder.maxResults;
        this.minDuration = builder.minDuration;
        this.nextToken = builder.nextToken;
        this.offeringId = builder.offeringId;
    }

    public List<Filter> filter() {
        return this.filter;
    }

    public Integer maxDuration() {
        return this.maxDuration;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Integer minDuration() {
        return this.minDuration;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String offeringId() {
        return this.offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.minDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsRequest)) {
            return false;
        }
        DescribeHostReservationOfferingsRequest other = (DescribeHostReservationOfferingsRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.maxDuration(), other.maxDuration()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.minDuration(), other.minDuration()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.offeringId(), other.offeringId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.maxDuration() != null) {
            sb.append("MaxDuration: ").append(this.maxDuration()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.minDuration() != null) {
            sb.append("MinDuration: ").append(this.minDuration()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.offeringId() != null) {
            sb.append("OfferingId: ").append(this.offeringId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
            case "MaxDuration": {
                return Optional.of(clazz.cast(this.maxDuration()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "MinDuration": {
                return Optional.of(clazz.cast(this.minDuration()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "OfferingId": {
                return Optional.of(clazz.cast(this.offeringId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<Filter> filter;
        private Integer maxDuration;
        private Integer maxResults;
        private Integer minDuration;
        private String nextToken;
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsRequest model) {
            this.filter(model.filter);
            this.maxDuration(model.maxDuration);
            this.maxResults(model.maxResults);
            this.minDuration(model.minDuration);
            this.nextToken(model.nextToken);
            this.offeringId(model.offeringId);
        }

        public final Collection<Filter.Builder> getFilter() {
            return this.filter != null ? (Collection)this.filter.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        public final Integer getMaxDuration() {
            return this.maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMinDuration() {
            return this.minDuration;
        }

        @Override
        public final Builder minDuration(Integer minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final void setMinDuration(Integer minDuration) {
            this.minDuration = minDuration;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeHostReservationOfferingsRequest build() {
            return new DescribeHostReservationOfferingsRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeHostReservationOfferingsRequest> {
        public Builder filter(Collection<Filter> var1);

        public Builder filter(Filter ... var1);

        public Builder maxDuration(Integer var1);

        public Builder maxResults(Integer var1);

        public Builder minDuration(Integer var1);

        public Builder nextToken(String var1);

        public Builder offeringId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

