/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.ExportTaskIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeExportTasksRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeExportTasksRequest> {
    private final List<String> exportTaskIds;

    private DescribeExportTasksRequest(BuilderImpl builder) {
        super(builder);
        this.exportTaskIds = builder.exportTaskIds;
    }

    public List<String> exportTaskIds() {
        return this.exportTaskIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTaskIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksRequest)) {
            return false;
        }
        DescribeExportTasksRequest other = (DescribeExportTasksRequest)((Object)obj);
        return Objects.equals(this.exportTaskIds(), other.exportTaskIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.exportTaskIds() != null) {
            sb.append("ExportTaskIds: ").append(this.exportTaskIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportTaskIds": {
                return Optional.of(clazz.cast(this.exportTaskIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<String> exportTaskIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksRequest model) {
            this.exportTaskIds(model.exportTaskIds);
        }

        public final Collection<String> getExportTaskIds() {
            return this.exportTaskIds;
        }

        @Override
        public final Builder exportTaskIds(Collection<String> exportTaskIds) {
            this.exportTaskIds = ExportTaskIdStringListCopier.copy(exportTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTaskIds(String ... exportTaskIds) {
            this.exportTaskIds(Arrays.asList(exportTaskIds));
            return this;
        }

        public final void setExportTaskIds(Collection<String> exportTaskIds) {
            this.exportTaskIds = ExportTaskIdStringListCopier.copy(exportTaskIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeExportTasksRequest build() {
            return new DescribeExportTasksRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeExportTasksRequest> {
        public Builder exportTaskIds(Collection<String> var1);

        public Builder exportTaskIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

