/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVpcRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreateVpcRequest> {
    private final String cidrBlock;
    private final Boolean amazonProvidedIpv6CidrBlock;
    private final String instanceTenancy;

    private CreateVpcRequest(BuilderImpl builder) {
        super(builder);
        this.cidrBlock = builder.cidrBlock;
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
        this.instanceTenancy = builder.instanceTenancy;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public Boolean amazonProvidedIpv6CidrBlock() {
        return this.amazonProvidedIpv6CidrBlock;
    }

    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public String instanceTenancyString() {
        return this.instanceTenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonProvidedIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcRequest)) {
            return false;
        }
        CreateVpcRequest other = (CreateVpcRequest)((Object)obj);
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.amazonProvidedIpv6CidrBlock(), other.amazonProvidedIpv6CidrBlock()) && Objects.equals(this.instanceTenancyString(), other.instanceTenancyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.cidrBlock()).append(",");
        }
        if (this.amazonProvidedIpv6CidrBlock() != null) {
            sb.append("AmazonProvidedIpv6CidrBlock: ").append(this.amazonProvidedIpv6CidrBlock()).append(",");
        }
        if (this.instanceTenancyString() != null) {
            sb.append("InstanceTenancy: ").append(this.instanceTenancyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.of(clazz.cast(this.cidrBlock()));
            }
            case "AmazonProvidedIpv6CidrBlock": {
                return Optional.of(clazz.cast(this.amazonProvidedIpv6CidrBlock()));
            }
            case "InstanceTenancy": {
                return Optional.of(clazz.cast(this.instanceTenancyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String cidrBlock;
        private Boolean amazonProvidedIpv6CidrBlock;
        private String instanceTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcRequest model) {
            this.cidrBlock(model.cidrBlock);
            this.amazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
            this.instanceTenancy(model.instanceTenancy);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return this.amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcRequest build() {
            return new CreateVpcRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreateVpcRequest> {
        public Builder cidrBlock(String var1);

        public Builder amazonProvidedIpv6CidrBlock(Boolean var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

