/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ReplaceNetworkAclEntryRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReplaceNetworkAclEntryRequestMarshaller implements
        Marshaller<Request<ReplaceNetworkAclEntryRequest>, ReplaceNetworkAclEntryRequest> {

    public Request<ReplaceNetworkAclEntryRequest> marshall(ReplaceNetworkAclEntryRequest replaceNetworkAclEntryRequest) {

        if (replaceNetworkAclEntryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ReplaceNetworkAclEntryRequest> request = new DefaultRequest<ReplaceNetworkAclEntryRequest>(
                replaceNetworkAclEntryRequest, "EC2Client");
        request.addParameter("Action", "ReplaceNetworkAclEntry");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (replaceNetworkAclEntryRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString(replaceNetworkAclEntryRequest.cidrBlock()));
        }

        if (replaceNetworkAclEntryRequest.egress() != null) {
            request.addParameter("Egress", StringUtils.fromBoolean(replaceNetworkAclEntryRequest.egress()));
        }

        IcmpTypeCode icmpTypeCode = replaceNetworkAclEntryRequest.icmpTypeCode();
        if (icmpTypeCode != null) {

            if (icmpTypeCode.code() != null) {
                request.addParameter("Icmp.Code", StringUtils.fromInteger(icmpTypeCode.code()));
            }

            if (icmpTypeCode.type() != null) {
                request.addParameter("Icmp.Type", StringUtils.fromInteger(icmpTypeCode.type()));
            }
        }

        if (replaceNetworkAclEntryRequest.ipv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString(replaceNetworkAclEntryRequest.ipv6CidrBlock()));
        }

        if (replaceNetworkAclEntryRequest.networkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString(replaceNetworkAclEntryRequest.networkAclId()));
        }

        PortRange portRange = replaceNetworkAclEntryRequest.portRange();
        if (portRange != null) {

            if (portRange.from() != null) {
                request.addParameter("PortRange.From", StringUtils.fromInteger(portRange.from()));
            }

            if (portRange.to() != null) {
                request.addParameter("PortRange.To", StringUtils.fromInteger(portRange.to()));
            }
        }

        if (replaceNetworkAclEntryRequest.protocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(replaceNetworkAclEntryRequest.protocol()));
        }

        if (replaceNetworkAclEntryRequest.ruleActionString() != null) {
            request.addParameter("RuleAction", StringUtils.fromString(replaceNetworkAclEntryRequest.ruleActionString()));
        }

        if (replaceNetworkAclEntryRequest.ruleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger(replaceNetworkAclEntryRequest.ruleNumber()));
        }

        return request;
    }

}
