/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ModifySnapshotAttributeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ModifySnapshotAttributeRequestMarshaller implements
        Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {

    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {

        if (modifySnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifySnapshotAttributeRequest> request = new DefaultRequest<ModifySnapshotAttributeRequest>(
                modifySnapshotAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifySnapshotAttributeRequest.attributeString() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifySnapshotAttributeRequest.attributeString()));
        }

        CreateVolumePermissionModifications createVolumePermission = modifySnapshotAttributeRequest.createVolumePermission();
        if (createVolumePermission != null) {

            java.util.List<CreateVolumePermission> createVolumePermissionModificationsAddList = createVolumePermission.add();
            if (createVolumePermissionModificationsAddList != null) {
                int addListIndex = 1;

                for (CreateVolumePermission createVolumePermissionModificationsAddListValue : createVolumePermissionModificationsAddList) {

                    if (createVolumePermissionModificationsAddListValue.groupString() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group",
                                StringUtils.fromString(createVolumePermissionModificationsAddListValue.groupString()));
                    }

                    if (createVolumePermissionModificationsAddListValue.userId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId",
                                StringUtils.fromString(createVolumePermissionModificationsAddListValue.userId()));
                    }
                    addListIndex++;
                }
            }

            java.util.List<CreateVolumePermission> createVolumePermissionModificationsRemoveList = createVolumePermission
                    .remove();
            if (createVolumePermissionModificationsRemoveList != null) {
                int removeListIndex = 1;

                for (CreateVolumePermission createVolumePermissionModificationsRemoveListValue : createVolumePermissionModificationsRemoveList) {

                    if (createVolumePermissionModificationsRemoveListValue.groupString() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group",
                                StringUtils.fromString(createVolumePermissionModificationsRemoveListValue.groupString()));
                    }

                    if (createVolumePermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId",
                                StringUtils.fromString(createVolumePermissionModificationsRemoveListValue.userId()));
                    }
                    removeListIndex++;
                }
            }
        }

        java.util.List<String> modifySnapshotAttributeRequestGroupNamesList = modifySnapshotAttributeRequest.groupNames();
        if (modifySnapshotAttributeRequestGroupNamesList != null) {
            int groupNamesListIndex = 1;

            for (String modifySnapshotAttributeRequestGroupNamesListValue : modifySnapshotAttributeRequestGroupNamesList) {
                if (modifySnapshotAttributeRequestGroupNamesListValue != null) {
                    request.addParameter("UserGroup." + groupNamesListIndex,
                            StringUtils.fromString(modifySnapshotAttributeRequestGroupNamesListValue));
                }
                groupNamesListIndex++;
            }
        }

        if (modifySnapshotAttributeRequest.operationTypeString() != null) {
            request.addParameter("OperationType", StringUtils.fromString(modifySnapshotAttributeRequest.operationTypeString()));
        }

        if (modifySnapshotAttributeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString(modifySnapshotAttributeRequest.snapshotId()));
        }

        java.util.List<String> modifySnapshotAttributeRequestUserIdsList = modifySnapshotAttributeRequest.userIds();
        if (modifySnapshotAttributeRequestUserIdsList != null) {
            int userIdsListIndex = 1;

            for (String modifySnapshotAttributeRequestUserIdsListValue : modifySnapshotAttributeRequestUserIdsList) {
                if (modifySnapshotAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex,
                            StringUtils.fromString(modifySnapshotAttributeRequestUserIdsListValue));
                }
                userIdsListIndex++;
            }
        }

        return request;
    }

}
