/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeVpcEndpointsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeVpcEndpointsRequestMarshaller implements
        Marshaller<Request<DescribeVpcEndpointsRequest>, DescribeVpcEndpointsRequest> {

    public Request<DescribeVpcEndpointsRequest> marshall(DescribeVpcEndpointsRequest describeVpcEndpointsRequest) {

        if (describeVpcEndpointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeVpcEndpointsRequest> request = new DefaultRequest<DescribeVpcEndpointsRequest>(
                describeVpcEndpointsRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcEndpoints");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> describeVpcEndpointsRequestVpcEndpointIdsList = describeVpcEndpointsRequest.vpcEndpointIds();
        if (describeVpcEndpointsRequestVpcEndpointIdsList != null) {
            int vpcEndpointIdsListIndex = 1;

            for (String describeVpcEndpointsRequestVpcEndpointIdsListValue : describeVpcEndpointsRequestVpcEndpointIdsList) {
                if (describeVpcEndpointsRequestVpcEndpointIdsListValue != null) {
                    request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex,
                            StringUtils.fromString(describeVpcEndpointsRequestVpcEndpointIdsListValue));
                }
                vpcEndpointIdsListIndex++;
            }
        }

        java.util.List<Filter> describeVpcEndpointsRequestFiltersList = describeVpcEndpointsRequest.filters();
        if (describeVpcEndpointsRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeVpcEndpointsRequestFiltersListValue : describeVpcEndpointsRequestFiltersList) {

                if (describeVpcEndpointsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeVpcEndpointsRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeVpcEndpointsRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeVpcEndpointsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeVpcEndpointsRequest.maxResults()));
        }

        if (describeVpcEndpointsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeVpcEndpointsRequest.nextToken()));
        }

        return request;
    }

}
