/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeMovingAddressesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeMovingAddressesRequestMarshaller implements
        Marshaller<Request<DescribeMovingAddressesRequest>, DescribeMovingAddressesRequest> {

    public Request<DescribeMovingAddressesRequest> marshall(DescribeMovingAddressesRequest describeMovingAddressesRequest) {

        if (describeMovingAddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeMovingAddressesRequest> request = new DefaultRequest<DescribeMovingAddressesRequest>(
                describeMovingAddressesRequest, "EC2Client");
        request.addParameter("Action", "DescribeMovingAddresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeMovingAddressesRequestFiltersList = describeMovingAddressesRequest.filters();
        if (describeMovingAddressesRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeMovingAddressesRequestFiltersListValue : describeMovingAddressesRequestFiltersList) {

                if (describeMovingAddressesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeMovingAddressesRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeMovingAddressesRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeMovingAddressesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeMovingAddressesRequest.maxResults()));
        }

        if (describeMovingAddressesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeMovingAddressesRequest.nextToken()));
        }

        java.util.List<String> describeMovingAddressesRequestPublicIpsList = describeMovingAddressesRequest.publicIps();
        if (describeMovingAddressesRequestPublicIpsList != null) {
            int publicIpsListIndex = 1;

            for (String describeMovingAddressesRequestPublicIpsListValue : describeMovingAddressesRequestPublicIpsList) {
                if (describeMovingAddressesRequestPublicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex,
                            StringUtils.fromString(describeMovingAddressesRequestPublicIpsListValue));
                }
                publicIpsListIndex++;
            }
        }

        return request;
    }

}
