/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeInstancesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeInstancesResponseUnmarshaller implements Unmarshaller<DescribeInstancesResponse, StaxUnmarshallerContext> {

    public DescribeInstancesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeInstancesResponse.Builder describeInstancesResponse = DescribeInstancesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Reservation> reservations = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeInstancesResponse.reservations(reservations);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("reservationSet", targetDepth)) {
                    reservations = new ArrayList<Reservation>();
                    continue;
                }

                if (context.testExpression("reservationSet/item", targetDepth)) {
                    reservations.add(ReservationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeInstancesResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeInstancesResponse.reservations(reservations);
                    break;
                }
            }
        }
        return describeInstancesResponse.build();
    }

    private static final DescribeInstancesResponseUnmarshaller INSTANCE = new DescribeInstancesResponseUnmarshaller();

    public static DescribeInstancesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
