/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeInstanceStatusRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeInstanceStatusRequestMarshaller implements
        Marshaller<Request<DescribeInstanceStatusRequest>, DescribeInstanceStatusRequest> {

    public Request<DescribeInstanceStatusRequest> marshall(DescribeInstanceStatusRequest describeInstanceStatusRequest) {

        if (describeInstanceStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeInstanceStatusRequest> request = new DefaultRequest<DescribeInstanceStatusRequest>(
                describeInstanceStatusRequest, "EC2Client");
        request.addParameter("Action", "DescribeInstanceStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeInstanceStatusRequestFiltersList = describeInstanceStatusRequest.filters();
        if (describeInstanceStatusRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeInstanceStatusRequestFiltersListValue : describeInstanceStatusRequestFiltersList) {

                if (describeInstanceStatusRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeInstanceStatusRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeInstanceStatusRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        java.util.List<String> describeInstanceStatusRequestInstanceIdsList = describeInstanceStatusRequest.instanceIds();
        if (describeInstanceStatusRequestInstanceIdsList != null) {
            int instanceIdsListIndex = 1;

            for (String describeInstanceStatusRequestInstanceIdsListValue : describeInstanceStatusRequestInstanceIdsList) {
                if (describeInstanceStatusRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex,
                            StringUtils.fromString(describeInstanceStatusRequestInstanceIdsListValue));
                }
                instanceIdsListIndex++;
            }
        }

        if (describeInstanceStatusRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeInstanceStatusRequest.maxResults()));
        }

        if (describeInstanceStatusRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeInstanceStatusRequest.nextToken()));
        }

        if (describeInstanceStatusRequest.includeAllInstances() != null) {
            request.addParameter("IncludeAllInstances",
                    StringUtils.fromBoolean(describeInstanceStatusRequest.includeAllInstances()));
        }

        return request;
    }

}
