/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateFpgaImageRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateFpgaImageRequestMarshaller implements Marshaller<Request<CreateFpgaImageRequest>, CreateFpgaImageRequest> {

    public Request<CreateFpgaImageRequest> marshall(CreateFpgaImageRequest createFpgaImageRequest) {

        if (createFpgaImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateFpgaImageRequest> request = new DefaultRequest<CreateFpgaImageRequest>(createFpgaImageRequest, "EC2Client");
        request.addParameter("Action", "CreateFpgaImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        StorageLocation inputStorageLocation = createFpgaImageRequest.inputStorageLocation();
        if (inputStorageLocation != null) {

            if (inputStorageLocation.bucket() != null) {
                request.addParameter("InputStorageLocation.Bucket", StringUtils.fromString(inputStorageLocation.bucket()));
            }

            if (inputStorageLocation.key() != null) {
                request.addParameter("InputStorageLocation.Key", StringUtils.fromString(inputStorageLocation.key()));
            }
        }

        StorageLocation logsStorageLocation = createFpgaImageRequest.logsStorageLocation();
        if (logsStorageLocation != null) {

            if (logsStorageLocation.bucket() != null) {
                request.addParameter("LogsStorageLocation.Bucket", StringUtils.fromString(logsStorageLocation.bucket()));
            }

            if (logsStorageLocation.key() != null) {
                request.addParameter("LogsStorageLocation.Key", StringUtils.fromString(logsStorageLocation.key()));
            }
        }

        if (createFpgaImageRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(createFpgaImageRequest.description()));
        }

        if (createFpgaImageRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString(createFpgaImageRequest.name()));
        }

        if (createFpgaImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createFpgaImageRequest.clientToken()));
        }

        return request;
    }

}
