/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ClassicLoadBalancersConfig StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ClassicLoadBalancersConfigUnmarshaller implements Unmarshaller<ClassicLoadBalancersConfig, StaxUnmarshallerContext> {

    public ClassicLoadBalancersConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        ClassicLoadBalancersConfig.Builder classicLoadBalancersConfig = ClassicLoadBalancersConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ClassicLoadBalancer> classicLoadBalancers = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                classicLoadBalancersConfig.classicLoadBalancers(classicLoadBalancers);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("classicLoadBalancers", targetDepth)) {
                    classicLoadBalancers = new ArrayList<ClassicLoadBalancer>();
                    continue;
                }

                if (context.testExpression("classicLoadBalancers/item", targetDepth)) {
                    classicLoadBalancers.add(ClassicLoadBalancerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    classicLoadBalancersConfig.classicLoadBalancers(classicLoadBalancers);
                    break;
                }
            }
        }
        return classicLoadBalancersConfig.build();
    }

    private static final ClassicLoadBalancersConfigUnmarshaller INSTANCE = new ClassicLoadBalancersConfigUnmarshaller();

    public static ClassicLoadBalancersConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}
