/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a volume status event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeStatusEvent implements ToCopyableBuilder<VolumeStatusEvent.Builder, VolumeStatusEvent> {
    private final String description;

    private final String eventId;

    private final String eventType;

    private final Instant notAfter;

    private final Instant notBefore;

    private VolumeStatusEvent(BuilderImpl builder) {
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
    }

    /**
     * <p>
     * A description of the event.
     * </p>
     * 
     * @return A description of the event.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of this event.
     * </p>
     * 
     * @return The ID of this event.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The type of this event.
     * </p>
     * 
     * @return The type of this event.
     */
    public String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The latest end time of the event.
     * </p>
     * 
     * @return The latest end time of the event.
     */
    public Instant notAfter() {
        return notAfter;
    }

    /**
     * <p>
     * The earliest start time of the event.
     * </p>
     * 
     * @return The earliest start time of the event.
     */
    public Instant notBefore() {
        return notBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(notBefore());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusEvent)) {
            return false;
        }
        VolumeStatusEvent other = (VolumeStatusEvent) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(eventType(), other.eventType()) && Objects.equals(notAfter(), other.notAfter())
                && Objects.equals(notBefore(), other.notBefore());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (eventId() != null) {
            sb.append("EventId: ").append(eventId()).append(",");
        }
        if (eventType() != null) {
            sb.append("EventType: ").append(eventType()).append(",");
        }
        if (notAfter() != null) {
            sb.append("NotAfter: ").append(notAfter()).append(",");
        }
        if (notBefore() != null) {
            sb.append("NotBefore: ").append(notBefore()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "EventId":
            return Optional.of(clazz.cast(eventId()));
        case "EventType":
            return Optional.of(clazz.cast(eventType()));
        case "NotAfter":
            return Optional.of(clazz.cast(notAfter()));
        case "NotBefore":
            return Optional.of(clazz.cast(notBefore()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeStatusEvent> {
        /**
         * <p>
         * A description of the event.
         * </p>
         * 
         * @param description
         *        A description of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of this event.
         * </p>
         * 
         * @param eventId
         *        The ID of this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The type of this event.
         * </p>
         * 
         * @param eventType
         *        The type of this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The latest end time of the event.
         * </p>
         * 
         * @param notAfter
         *        The latest end time of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAfter(Instant notAfter);

        /**
         * <p>
         * The earliest start time of the event.
         * </p>
         * 
         * @param notBefore
         *        The earliest start time of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notBefore(Instant notBefore);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String eventId;

        private String eventType;

        private Instant notAfter;

        private Instant notBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusEvent model) {
            description(model.description);
            eventId(model.eventId);
            eventType(model.eventType);
            notAfter(model.notAfter);
            notBefore(model.notBefore);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getNotAfter() {
            return notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final Instant getNotBefore() {
            return notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        public VolumeStatusEvent build() {
            return new VolumeStatusEvent(this);
        }
    }
}
