/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of TerminateInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TerminateInstancesResponse extends EC2Response implements
        ToCopyableBuilder<TerminateInstancesResponse.Builder, TerminateInstancesResponse> {
    private final List<InstanceStateChange> terminatingInstances;

    private TerminateInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.terminatingInstances = builder.terminatingInstances;
    }

    /**
     * <p>
     * Information about one or more terminated instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more terminated instances.
     */
    public List<InstanceStateChange> terminatingInstances() {
        return terminatingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(terminatingInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstancesResponse)) {
            return false;
        }
        TerminateInstancesResponse other = (TerminateInstancesResponse) obj;
        return Objects.equals(terminatingInstances(), other.terminatingInstances());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (terminatingInstances() != null) {
            sb.append("TerminatingInstances: ").append(terminatingInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminatingInstances":
            return Optional.of(clazz.cast(terminatingInstances()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, TerminateInstancesResponse> {
        /**
         * <p>
         * Information about one or more terminated instances.
         * </p>
         * 
         * @param terminatingInstances
         *        Information about one or more terminated instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminatingInstances(Collection<InstanceStateChange> terminatingInstances);

        /**
         * <p>
         * Information about one or more terminated instances.
         * </p>
         * 
         * @param terminatingInstances
         *        Information about one or more terminated instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminatingInstances(InstanceStateChange... terminatingInstances);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<InstanceStateChange> terminatingInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstancesResponse model) {
            terminatingInstances(model.terminatingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getTerminatingInstances() {
            return terminatingInstances != null ? terminatingInstances.stream().map(InstanceStateChange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder terminatingInstances(Collection<InstanceStateChange> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copy(terminatingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminatingInstances(InstanceStateChange... terminatingInstances) {
            terminatingInstances(Arrays.asList(terminatingInstances));
            return this;
        }

        public final void setTerminatingInstances(Collection<InstanceStateChange.BuilderImpl> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copyFromBuilder(terminatingInstances);
        }

        @Override
        public TerminateInstancesResponse build() {
            return new TerminateInstancesResponse(this);
        }
    }
}
