/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of RequestSpotFleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RequestSpotFleetResponse extends EC2Response implements
        ToCopyableBuilder<RequestSpotFleetResponse.Builder, RequestSpotFleetResponse> {
    private final String spotFleetRequestId;

    private RequestSpotFleetResponse(BuilderImpl builder) {
        super(builder);
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    /**
     * <p>
     * The ID of the Spot fleet request.
     * </p>
     * 
     * @return The ID of the Spot fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotFleetResponse)) {
            return false;
        }
        RequestSpotFleetResponse other = (RequestSpotFleetResponse) obj;
        return Objects.equals(spotFleetRequestId(), other.spotFleetRequestId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(spotFleetRequestId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotFleetRequestId":
            return Optional.of(clazz.cast(spotFleetRequestId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, RequestSpotFleetResponse> {
        /**
         * <p>
         * The ID of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotFleetResponse model) {
            spotFleetRequestId(model.spotFleetRequestId);
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public RequestSpotFleetResponse build() {
            return new RequestSpotFleetResponse(this);
        }
    }
}
