/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PricingDetail implements ToCopyableBuilder<PricingDetail.Builder, PricingDetail> {
    private final Integer count;

    private final Double price;

    private PricingDetail(BuilderImpl builder) {
        this.count = builder.count;
        this.price = builder.price;
    }

    /**
     * <p>
     * The number of reservations available for the price.
     * </p>
     * 
     * @return The number of reservations available for the price.
     */
    public Integer count() {
        return count;
    }

    /**
     * <p>
     * The price per instance.
     * </p>
     * 
     * @return The price per instance.
     */
    public Double price() {
        return price;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PricingDetail)) {
            return false;
        }
        PricingDetail other = (PricingDetail) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(price(), other.price());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (count() != null) {
            sb.append("Count: ").append(count()).append(",");
        }
        if (price() != null) {
            sb.append("Price: ").append(price()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.of(clazz.cast(count()));
        case "Price":
            return Optional.of(clazz.cast(price()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PricingDetail> {
        /**
         * <p>
         * The number of reservations available for the price.
         * </p>
         * 
         * @param count
         *        The number of reservations available for the price.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The price per instance.
         * </p>
         * 
         * @param price
         *        The price per instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Double price);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private Double price;

        private BuilderImpl() {
        }

        private BuilderImpl(PricingDetail model) {
            count(model.count);
            price(model.price);
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Double getPrice() {
            return price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        @Override
        public PricingDetail build() {
            return new PricingDetail(this);
        }
    }
}
