/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a permission for a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkInterfacePermission implements
        ToCopyableBuilder<NetworkInterfacePermission.Builder, NetworkInterfacePermission> {
    private final String networkInterfacePermissionId;

    private final String networkInterfaceId;

    private final String awsAccountId;

    private final String awsService;

    private final String permission;

    private final NetworkInterfacePermissionState permissionState;

    private NetworkInterfacePermission(BuilderImpl builder) {
        this.networkInterfacePermissionId = builder.networkInterfacePermissionId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.awsAccountId = builder.awsAccountId;
        this.awsService = builder.awsService;
        this.permission = builder.permission;
        this.permissionState = builder.permissionState;
    }

    /**
     * <p>
     * The ID of the network interface permission.
     * </p>
     * 
     * @return The ID of the network interface permission.
     */
    public String networkInterfacePermissionId() {
        return networkInterfacePermissionId;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The AWS service.
     * </p>
     * 
     * @return The AWS service.
     */
    public String awsService() {
        return awsService;
    }

    /**
     * <p>
     * The type of permission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link InterfacePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionString}.
     * </p>
     * 
     * @return The type of permission.
     * @see InterfacePermissionType
     */
    public InterfacePermissionType permission() {
        return InterfacePermissionType.fromValue(permission);
    }

    /**
     * <p>
     * The type of permission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link InterfacePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionString}.
     * </p>
     * 
     * @return The type of permission.
     * @see InterfacePermissionType
     */
    public String permissionString() {
        return permission;
    }

    /**
     * <p>
     * Information about the state of the permission.
     * </p>
     * 
     * @return Information about the state of the permission.
     */
    public NetworkInterfacePermissionState permissionState() {
        return permissionState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfacePermissionId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsService());
        hashCode = 31 * hashCode + Objects.hashCode(permissionString());
        hashCode = 31 * hashCode + Objects.hashCode(permissionState());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePermission)) {
            return false;
        }
        NetworkInterfacePermission other = (NetworkInterfacePermission) obj;
        return Objects.equals(networkInterfacePermissionId(), other.networkInterfacePermissionId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(awsService(), other.awsService())
                && Objects.equals(permissionString(), other.permissionString())
                && Objects.equals(permissionState(), other.permissionState());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (networkInterfacePermissionId() != null) {
            sb.append("NetworkInterfacePermissionId: ").append(networkInterfacePermissionId()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (awsAccountId() != null) {
            sb.append("AwsAccountId: ").append(awsAccountId()).append(",");
        }
        if (awsService() != null) {
            sb.append("AwsService: ").append(awsService()).append(",");
        }
        if (permissionString() != null) {
            sb.append("Permission: ").append(permissionString()).append(",");
        }
        if (permissionState() != null) {
            sb.append("PermissionState: ").append(permissionState()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfacePermissionId":
            return Optional.of(clazz.cast(networkInterfacePermissionId()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "AwsAccountId":
            return Optional.of(clazz.cast(awsAccountId()));
        case "AwsService":
            return Optional.of(clazz.cast(awsService()));
        case "Permission":
            return Optional.of(clazz.cast(permissionString()));
        case "PermissionState":
            return Optional.of(clazz.cast(permissionState()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkInterfacePermission> {
        /**
         * <p>
         * The ID of the network interface permission.
         * </p>
         * 
         * @param networkInterfacePermissionId
         *        The ID of the network interface permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePermissionId(String networkInterfacePermissionId);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The AWS service.
         * </p>
         * 
         * @param awsService
         *        The AWS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsService(String awsService);

        /**
         * <p>
         * The type of permission.
         * </p>
         * 
         * @param permission
         *        The type of permission.
         * @see InterfacePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfacePermissionType
         */
        Builder permission(String permission);

        /**
         * <p>
         * The type of permission.
         * </p>
         * 
         * @param permission
         *        The type of permission.
         * @see InterfacePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfacePermissionType
         */
        Builder permission(InterfacePermissionType permission);

        /**
         * <p>
         * Information about the state of the permission.
         * </p>
         * 
         * @param permissionState
         *        Information about the state of the permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionState(NetworkInterfacePermissionState permissionState);

        /**
         * <p>
         * Information about the state of the permission.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterfacePermissionState.Builder}
         * avoiding the need to create one manually via {@link NetworkInterfacePermissionState#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterfacePermissionState.Builder#build()} is called
         * immediately and its result is passed to {@link #permissionState(NetworkInterfacePermissionState)}.
         * 
         * @param permissionState
         *        a consumer that will call methods on {@link NetworkInterfacePermissionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionState(NetworkInterfacePermissionState)
         */
        default Builder permissionState(Consumer<NetworkInterfacePermissionState.Builder> permissionState) {
            return permissionState(NetworkInterfacePermissionState.builder().apply(permissionState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfacePermissionId;

        private String networkInterfaceId;

        private String awsAccountId;

        private String awsService;

        private String permission;

        private NetworkInterfacePermissionState permissionState;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePermission model) {
            networkInterfacePermissionId(model.networkInterfacePermissionId);
            networkInterfaceId(model.networkInterfaceId);
            awsAccountId(model.awsAccountId);
            awsService(model.awsService);
            permission(model.permission);
            permissionState(model.permissionState);
        }

        public final String getNetworkInterfacePermissionId() {
            return networkInterfacePermissionId;
        }

        @Override
        public final Builder networkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
            return this;
        }

        public final void setNetworkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getAwsService() {
            return awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        public final String getPermission() {
            return permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(InterfacePermissionType permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public final NetworkInterfacePermissionState.Builder getPermissionState() {
            return permissionState != null ? permissionState.toBuilder() : null;
        }

        @Override
        public final Builder permissionState(NetworkInterfacePermissionState permissionState) {
            this.permissionState = permissionState;
            return this;
        }

        public final void setPermissionState(NetworkInterfacePermissionState.BuilderImpl permissionState) {
            this.permissionState = permissionState != null ? permissionState.build() : null;
        }

        @Override
        public NetworkInterfacePermission build() {
            return new NetworkInterfacePermission(this);
        }
    }
}
