/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of MoveAddressToVpc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MoveAddressToVpcResponse extends EC2Response implements
        ToCopyableBuilder<MoveAddressToVpcResponse.Builder, MoveAddressToVpcResponse> {
    private final String allocationId;

    private final String status;

    private MoveAddressToVpcResponse(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The allocation ID for the Elastic IP address.
     * </p>
     * 
     * @return The allocation ID for the Elastic IP address.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The status of the move of the IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the move of the IP address.
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the move of the IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the move of the IP address.
     * @see Status
     */
    public String statusString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveAddressToVpcResponse)) {
            return false;
        }
        MoveAddressToVpcResponse other = (MoveAddressToVpcResponse) obj;
        return Objects.equals(allocationId(), other.allocationId()) && Objects.equals(statusString(), other.statusString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (allocationId() != null) {
            sb.append("AllocationId: ").append(allocationId()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.of(clazz.cast(allocationId()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, MoveAddressToVpcResponse> {
        /**
         * <p>
         * The allocation ID for the Elastic IP address.
         * </p>
         * 
         * @param allocationId
         *        The allocation ID for the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The status of the move of the IP address.
         * </p>
         * 
         * @param status
         *        The status of the move of the IP address.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the move of the IP address.
         * </p>
         * 
         * @param status
         *        The status of the move of the IP address.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String allocationId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveAddressToVpcResponse model) {
            allocationId(model.allocationId);
            status(model.status);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public MoveAddressToVpcResponse build() {
            return new MoveAddressToVpcResponse(this);
        }
    }
}
