/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyFpgaImageAttributeRequest extends EC2Request implements
        ToCopyableBuilder<ModifyFpgaImageAttributeRequest.Builder, ModifyFpgaImageAttributeRequest> {
    private final String fpgaImageId;

    private final String attribute;

    private final String operationType;

    private final List<String> userIds;

    private final List<String> userGroups;

    private final List<String> productCodes;

    private final LoadPermissionModifications loadPermission;

    private final String description;

    private final String name;

    private ModifyFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
        this.operationType = builder.operationType;
        this.userIds = builder.userIds;
        this.userGroups = builder.userGroups;
        this.productCodes = builder.productCodes;
        this.loadPermission = builder.loadPermission;
        this.description = builder.description;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ID of the AFI.
     * </p>
     * 
     * @return The ID of the AFI.
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link FpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeString}.
     * </p>
     * 
     * @return The name of the attribute.
     * @see FpgaImageAttributeName
     */
    public FpgaImageAttributeName attribute() {
        return FpgaImageAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link FpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeString}.
     * </p>
     * 
     * @return The name of the attribute.
     * @see FpgaImageAttributeName
     */
    public String attributeString() {
        return attribute;
    }

    /**
     * <p>
     * The operation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeString}.
     * </p>
     * 
     * @return The operation type.
     * @see OperationType
     */
    public OperationType operationType() {
        return OperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The operation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeString}.
     * </p>
     * 
     * @return The operation type.
     * @see OperationType
     */
    public String operationTypeString() {
        return operationType;
    }

    /**
     * <p>
     * One or more AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code>
     * attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code>
     *         attribute.
     */
    public List<String> userIds() {
        return userIds;
    }

    /**
     * <p>
     * One or more user groups. This parameter is valid only when modifying the <code>loadPermission</code> attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user groups. This parameter is valid only when modifying the <code>loadPermission</code>
     *         attribute.
     */
    public List<String> userGroups() {
        return userGroups;
    }

    /**
     * <p>
     * One or more product codes. After you add a product code to an AFI, it can't be removed. This parameter is valid
     * only when modifying the <code>productCodes</code> attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more product codes. After you add a product code to an AFI, it can't be removed. This parameter is
     *         valid only when modifying the <code>productCodes</code> attribute.
     */
    public List<String> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The load permission for the AFI.
     * </p>
     * 
     * @return The load permission for the AFI.
     */
    public LoadPermissionModifications loadPermission() {
        return loadPermission;
    }

    /**
     * <p>
     * A description for the AFI.
     * </p>
     * 
     * @return A description for the AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A name for the AFI.
     * </p>
     * 
     * @return A name for the AFI.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeString());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(userIds());
        hashCode = 31 * hashCode + Objects.hashCode(userGroups());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(loadPermission());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFpgaImageAttributeRequest)) {
            return false;
        }
        ModifyFpgaImageAttributeRequest other = (ModifyFpgaImageAttributeRequest) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId()) && Objects.equals(attributeString(), other.attributeString())
                && Objects.equals(operationTypeString(), other.operationTypeString())
                && Objects.equals(userIds(), other.userIds()) && Objects.equals(userGroups(), other.userGroups())
                && Objects.equals(productCodes(), other.productCodes())
                && Objects.equals(loadPermission(), other.loadPermission()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fpgaImageId() != null) {
            sb.append("FpgaImageId: ").append(fpgaImageId()).append(",");
        }
        if (attributeString() != null) {
            sb.append("Attribute: ").append(attributeString()).append(",");
        }
        if (operationTypeString() != null) {
            sb.append("OperationType: ").append(operationTypeString()).append(",");
        }
        if (userIds() != null) {
            sb.append("UserIds: ").append(userIds()).append(",");
        }
        if (userGroups() != null) {
            sb.append("UserGroups: ").append(userGroups()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (loadPermission() != null) {
            sb.append("LoadPermission: ").append(loadPermission()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.of(clazz.cast(fpgaImageId()));
        case "Attribute":
            return Optional.of(clazz.cast(attributeString()));
        case "OperationType":
            return Optional.of(clazz.cast(operationTypeString()));
        case "UserIds":
            return Optional.of(clazz.cast(userIds()));
        case "UserGroups":
            return Optional.of(clazz.cast(userGroups()));
        case "ProductCodes":
            return Optional.of(clazz.cast(productCodes()));
        case "LoadPermission":
            return Optional.of(clazz.cast(loadPermission()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ModifyFpgaImageAttributeRequest> {
        /**
         * <p>
         * The ID of the AFI.
         * </p>
         * 
         * @param fpgaImageId
         *        The ID of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute.
         * @see FpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute.
         * @see FpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageAttributeName
         */
        Builder attribute(FpgaImageAttributeName attribute);

        /**
         * <p>
         * The operation type.
         * </p>
         * 
         * @param operationType
         *        The operation type.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The operation type.
         * </p>
         * 
         * @param operationType
         *        The operation type.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * One or more AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code>
         * attribute.
         * </p>
         * 
         * @param userIds
         *        One or more AWS account IDs. This parameter is valid only when modifying the
         *        <code>loadPermission</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * One or more AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code>
         * attribute.
         * </p>
         * 
         * @param userIds
         *        One or more AWS account IDs. This parameter is valid only when modifying the
         *        <code>loadPermission</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * One or more user groups. This parameter is valid only when modifying the <code>loadPermission</code>
         * attribute.
         * </p>
         * 
         * @param userGroups
         *        One or more user groups. This parameter is valid only when modifying the <code>loadPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<String> userGroups);

        /**
         * <p>
         * One or more user groups. This parameter is valid only when modifying the <code>loadPermission</code>
         * attribute.
         * </p>
         * 
         * @param userGroups
         *        One or more user groups. This parameter is valid only when modifying the <code>loadPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(String... userGroups);

        /**
         * <p>
         * One or more product codes. After you add a product code to an AFI, it can't be removed. This parameter is
         * valid only when modifying the <code>productCodes</code> attribute.
         * </p>
         * 
         * @param productCodes
         *        One or more product codes. After you add a product code to an AFI, it can't be removed. This parameter
         *        is valid only when modifying the <code>productCodes</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<String> productCodes);

        /**
         * <p>
         * One or more product codes. After you add a product code to an AFI, it can't be removed. This parameter is
         * valid only when modifying the <code>productCodes</code> attribute.
         * </p>
         * 
         * @param productCodes
         *        One or more product codes. After you add a product code to an AFI, it can't be removed. This parameter
         *        is valid only when modifying the <code>productCodes</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(String... productCodes);

        /**
         * <p>
         * The load permission for the AFI.
         * </p>
         * 
         * @param loadPermission
         *        The load permission for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadPermission(LoadPermissionModifications loadPermission);

        /**
         * <p>
         * The load permission for the AFI.
         * </p>
         * This is a convenience that creates an instance of the {@link LoadPermissionModifications.Builder} avoiding
         * the need to create one manually via {@link LoadPermissionModifications#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadPermissionModifications.Builder#build()} is called
         * immediately and its result is passed to {@link #loadPermission(LoadPermissionModifications)}.
         * 
         * @param loadPermission
         *        a consumer that will call methods on {@link LoadPermissionModifications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadPermission(LoadPermissionModifications)
         */
        default Builder loadPermission(Consumer<LoadPermissionModifications.Builder> loadPermission) {
            return loadPermission(LoadPermissionModifications.builder().apply(loadPermission).build());
        }

        /**
         * <p>
         * A description for the AFI.
         * </p>
         * 
         * @param description
         *        A description for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the AFI.
         * </p>
         * 
         * @param name
         *        A name for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String fpgaImageId;

        private String attribute;

        private String operationType;

        private List<String> userIds;

        private List<String> userGroups;

        private List<String> productCodes;

        private LoadPermissionModifications loadPermission;

        private String description;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyFpgaImageAttributeRequest model) {
            fpgaImageId(model.fpgaImageId);
            attribute(model.attribute);
            operationType(model.operationType);
            userIds(model.userIds);
            userGroups(model.userGroups);
            productCodes(model.productCodes);
            loadPermission(model.loadPermission);
            description(model.description);
            name(model.name);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(FpgaImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getOperationType() {
            return operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final Collection<String> getUserIds() {
            return userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        public final Collection<String> getUserGroups() {
            return userGroups;
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
        }

        public final Collection<String> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(String... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
        }

        public final LoadPermissionModifications.Builder getLoadPermission() {
            return loadPermission != null ? loadPermission.toBuilder() : null;
        }

        @Override
        public final Builder loadPermission(LoadPermissionModifications loadPermission) {
            this.loadPermission = loadPermission;
            return this;
        }

        public final void setLoadPermission(LoadPermissionModifications.BuilderImpl loadPermission) {
            this.loadPermission = loadPermission != null ? loadPermission.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyFpgaImageAttributeRequest build() {
            return new ModifyFpgaImageAttributeRequest(this);
        }
    }
}
