/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes modifications to the load permissions of an Amazon FPGA image (AFI).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LoadPermissionModifications implements
        ToCopyableBuilder<LoadPermissionModifications.Builder, LoadPermissionModifications> {
    private final List<LoadPermissionRequest> add;

    private final List<LoadPermissionRequest> remove;

    private LoadPermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    /**
     * <p>
     * The load permissions to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The load permissions to add.
     */
    public List<LoadPermissionRequest> add() {
        return add;
    }

    /**
     * <p>
     * The load permissions to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The load permissions to remove.
     */
    public List<LoadPermissionRequest> remove() {
        return remove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(add());
        hashCode = 31 * hashCode + Objects.hashCode(remove());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadPermissionModifications)) {
            return false;
        }
        LoadPermissionModifications other = (LoadPermissionModifications) obj;
        return Objects.equals(add(), other.add()) && Objects.equals(remove(), other.remove());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (add() != null) {
            sb.append("Add: ").append(add()).append(",");
        }
        if (remove() != null) {
            sb.append("Remove: ").append(remove()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Add":
            return Optional.of(clazz.cast(add()));
        case "Remove":
            return Optional.of(clazz.cast(remove()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LoadPermissionModifications> {
        /**
         * <p>
         * The load permissions to add.
         * </p>
         * 
         * @param add
         *        The load permissions to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(Collection<LoadPermissionRequest> add);

        /**
         * <p>
         * The load permissions to add.
         * </p>
         * 
         * @param add
         *        The load permissions to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(LoadPermissionRequest... add);

        /**
         * <p>
         * The load permissions to remove.
         * </p>
         * 
         * @param remove
         *        The load permissions to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(Collection<LoadPermissionRequest> remove);

        /**
         * <p>
         * The load permissions to remove.
         * </p>
         * 
         * @param remove
         *        The load permissions to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(LoadPermissionRequest... remove);
    }

    static final class BuilderImpl implements Builder {
        private List<LoadPermissionRequest> add;

        private List<LoadPermissionRequest> remove;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadPermissionModifications model) {
            add(model.add);
            remove(model.remove);
        }

        public final Collection<LoadPermissionRequest.Builder> getAdd() {
            return add != null ? add.stream().map(LoadPermissionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder add(Collection<LoadPermissionRequest> add) {
            this.add = LoadPermissionListRequestCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(LoadPermissionRequest... add) {
            add(Arrays.asList(add));
            return this;
        }

        public final void setAdd(Collection<LoadPermissionRequest.BuilderImpl> add) {
            this.add = LoadPermissionListRequestCopier.copyFromBuilder(add);
        }

        public final Collection<LoadPermissionRequest.Builder> getRemove() {
            return remove != null ? remove.stream().map(LoadPermissionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remove(Collection<LoadPermissionRequest> remove) {
            this.remove = LoadPermissionListRequestCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(LoadPermissionRequest... remove) {
            remove(Arrays.asList(remove));
            return this;
        }

        public final void setRemove(Collection<LoadPermissionRequest.BuilderImpl> remove) {
            this.remove = LoadPermissionListRequestCopier.copyFromBuilder(remove);
        }

        @Override
        public LoadPermissionModifications build() {
            return new LoadPermissionModifications(this);
        }
    }
}
