/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv6 address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceIpv6Address implements ToCopyableBuilder<InstanceIpv6Address.Builder, InstanceIpv6Address> {
    private final String ipv6Address;

    private InstanceIpv6Address(BuilderImpl builder) {
        this.ipv6Address = builder.ipv6Address;
    }

    /**
     * <p>
     * The IPv6 address.
     * </p>
     * 
     * @return The IPv6 address.
     */
    public String ipv6Address() {
        return ipv6Address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Address());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceIpv6Address)) {
            return false;
        }
        InstanceIpv6Address other = (InstanceIpv6Address) obj;
        return Objects.equals(ipv6Address(), other.ipv6Address());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ipv6Address() != null) {
            sb.append("Ipv6Address: ").append(ipv6Address()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Address":
            return Optional.of(clazz.cast(ipv6Address()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceIpv6Address> {
        /**
         * <p>
         * The IPv6 address.
         * </p>
         * 
         * @param ipv6Address
         *        The IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Address(String ipv6Address);
    }

    static final class BuilderImpl implements Builder {
        private String ipv6Address;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceIpv6Address model) {
            ipv6Address(model.ipv6Address);
        }

        public final String getIpv6Address() {
            return ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        public InstanceIpv6Address build() {
            return new InstanceIpv6Address(this);
        }
    }
}
