/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Instance implements ToCopyableBuilder<Instance.Builder, Instance> {
    private final Integer amiLaunchIndex;

    private final String imageId;

    private final String instanceId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final Instant launchTime;

    private final Monitoring monitoring;

    private final Placement placement;

    private final String platform;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<ProductCode> productCodes;

    private final String publicDnsName;

    private final String publicIpAddress;

    private final String ramdiskId;

    private final InstanceState state;

    private final String stateTransitionReason;

    private final String subnetId;

    private final String vpcId;

    private final String architecture;

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final String clientToken;

    private final Boolean ebsOptimized;

    private final Boolean enaSupport;

    private final String hypervisor;

    private final IamInstanceProfile iamInstanceProfile;

    private final String instanceLifecycle;

    private final List<ElasticGpuAssociation> elasticGpuAssociations;

    private final List<InstanceNetworkInterface> networkInterfaces;

    private final String rootDeviceName;

    private final String rootDeviceType;

    private final List<GroupIdentifier> securityGroups;

    private final Boolean sourceDestCheck;

    private final String spotInstanceRequestId;

    private final String sriovNetSupport;

    private final StateReason stateReason;

    private final List<Tag> tags;

    private final String virtualizationType;

    private Instance(BuilderImpl builder) {
        this.amiLaunchIndex = builder.amiLaunchIndex;
        this.imageId = builder.imageId;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.launchTime = builder.launchTime;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.platform = builder.platform;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.productCodes = builder.productCodes;
        this.publicDnsName = builder.publicDnsName;
        this.publicIpAddress = builder.publicIpAddress;
        this.ramdiskId = builder.ramdiskId;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.clientToken = builder.clientToken;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceLifecycle = builder.instanceLifecycle;
        this.elasticGpuAssociations = builder.elasticGpuAssociations;
        this.networkInterfaces = builder.networkInterfaces;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.securityGroups = builder.securityGroups;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
    }

    /**
     * <p>
     * The AMI launch index, which can be used to find this instance in the launch group.
     * </p>
     * 
     * @return The AMI launch index, which can be used to find this instance in the launch group.
     */
    public Integer amiLaunchIndex() {
        return amiLaunchIndex;
    }

    /**
     * <p>
     * The ID of the AMI used to launch the instance.
     * </p>
     * 
     * @return The ID of the AMI used to launch the instance.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type.
     * @see InstanceType
     */
    public String instanceTypeString() {
        return instanceType;
    }

    /**
     * <p>
     * The kernel associated with this instance, if applicable.
     * </p>
     * 
     * @return The kernel associated with this instance, if applicable.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair, if this instance was launched with an associated key pair.
     * </p>
     * 
     * @return The name of the key pair, if this instance was launched with an associated key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The time the instance was launched.
     * </p>
     * 
     * @return The time the instance was launched.
     */
    public Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public Monitoring monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The location where the instance launched, if applicable.
     * </p>
     * 
     * @return The location where the instance launched, if applicable.
     */
    public Placement placement() {
        return placement;
    }

    /**
     * <p>
     * The value is <code>Windows</code> for Windows instances; otherwise blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The value is <code>Windows</code> for Windows instances; otherwise blank.
     * @see PlatformValues
     */
    public PlatformValues platform() {
        return PlatformValues.fromValue(platform);
    }

    /**
     * <p>
     * The value is <code>Windows</code> for Windows instances; otherwise blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformString}.
     * </p>
     * 
     * @return The value is <code>Windows</code> for Windows instances; otherwise blank.
     * @see PlatformValues
     */
    public String platformString() {
        return platform;
    }

    /**
     * <p>
     * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the
     * Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state.
     * </p>
     * <p>
     * [EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS
     * resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your
     * custom domain name servers must resolve the hostname as appropriate.
     * </p>
     * 
     * @return (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used
     *         inside the Amazon EC2 network. This name is not available until the instance enters the
     *         <code>running</code> state. </p>
     *         <p>
     *         [EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled
     *         DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your
     *         VPC, your custom domain name servers must resolve the hostname as appropriate.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The private IPv4 address assigned to the instance.
     * </p>
     * 
     * @return The private IPv4 address assigned to the instance.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The product codes attached to this instance, if applicable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The product codes attached to this instance, if applicable.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance enters
     * the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS hostnames for your
     * VPC.
     * </p>
     * 
     * @return (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance
     *         enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS
     *         hostnames for your VPC.
     */
    public String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The public IPv4 address assigned to the instance, if applicable.
     * </p>
     * 
     * @return The public IPv4 address assigned to the instance, if applicable.
     */
    public String publicIpAddress() {
        return publicIpAddress;
    }

    /**
     * <p>
     * The RAM disk associated with this instance, if applicable.
     * </p>
     * 
     * @return The RAM disk associated with this instance, if applicable.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * 
     * @return The current state of the instance.
     */
    public InstanceState state() {
        return state;
    }

    /**
     * <p>
     * The reason for the most recent state transition. This might be an empty string.
     * </p>
     * 
     * @return The reason for the most recent state transition. This might be an empty string.
     */
    public String stateTransitionReason() {
        return stateTransitionReason;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the subnet in which the instance is running.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the subnet in which the instance is running.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the VPC in which the instance is running.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the VPC in which the instance is running.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(architecture);
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public String architectureString() {
        return architecture;
    }

    /**
     * <p>
     * Any block device mapping entries for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any block device mapping entries for the instance.
     */
    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The idempotency token you provided when you launched the instance, if applicable.
     * </p>
     * 
     * @return The idempotency token you provided when you launched the instance, if applicable.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
     *         optimization isn't available with all instance types. Additional usage charges apply when using an EBS
     *         Optimized instance.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with ENA is enabled.
     */
    public Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * The hypervisor type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorString}.
     * </p>
     * 
     * @return The hypervisor type of the instance.
     * @see HypervisorType
     */
    public HypervisorType hypervisor() {
        return HypervisorType.fromValue(hypervisor);
    }

    /**
     * <p>
     * The hypervisor type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorString}.
     * </p>
     * 
     * @return The hypervisor type of the instance.
     * @see HypervisorType
     */
    public String hypervisorString() {
        return hypervisor;
    }

    /**
     * <p>
     * The IAM instance profile associated with the instance, if applicable.
     * </p>
     * 
     * @return The IAM instance profile associated with the instance, if applicable.
     */
    public IamInstanceProfile iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceLifecycle}
     * will return {@link InstanceLifecycleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceLifecycleString}.
     * </p>
     * 
     * @return Indicates whether this is a Spot Instance or a Scheduled Instance.
     * @see InstanceLifecycleType
     */
    public InstanceLifecycleType instanceLifecycle() {
        return InstanceLifecycleType.fromValue(instanceLifecycle);
    }

    /**
     * <p>
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceLifecycle}
     * will return {@link InstanceLifecycleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceLifecycleString}.
     * </p>
     * 
     * @return Indicates whether this is a Spot Instance or a Scheduled Instance.
     * @see InstanceLifecycleType
     */
    public String instanceLifecycleString() {
        return instanceLifecycle;
    }

    /**
     * <p>
     * The Elastic GPU associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Elastic GPU associated with the instance.
     */
    public List<ElasticGpuAssociation> elasticGpuAssociations() {
        return elasticGpuAssociations;
    }

    /**
     * <p>
     * [EC2-VPC] One or more network interfaces for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-VPC] One or more network interfaces for the instance.
     */
    public List<InstanceNetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeString}.
     * </p>
     * 
     * @return The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public DeviceType rootDeviceType() {
        return DeviceType.fromValue(rootDeviceType);
    }

    /**
     * <p>
     * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeString}.
     * </p>
     * 
     * @return The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public String rootDeviceTypeString() {
        return rootDeviceType;
    }

    /**
     * <p>
     * One or more security groups for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security groups for the instance.
     */
    public List<GroupIdentifier> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
     * source/destination checking is enabled on the instance. A value of <code>true</code> means that checking is
     * enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the
     * instance to perform NAT. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the
     * <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
     *         source/destination checking is enabled on the instance. A value of <code>true</code> means that checking
     *         is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code>
     *         for the instance to perform NAT. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in
     *         the <i>Amazon Virtual Private Cloud User Guide</i>.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * If the request is a Spot Instance request, the ID of the request.
     * </p>
     * 
     * @return If the request is a Spot Instance request, the ID of the request.
     */
    public String spotInstanceRequestId() {
        return spotInstanceRequestId;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The reason for the most recent state transition.
     * </p>
     * 
     * @return The reason for the most recent state transition.
     */
    public StateReason stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * Any tags assigned to the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the instance.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The virtualization type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeString}.
     * </p>
     * 
     * @return The virtualization type of the instance.
     * @see VirtualizationType
     */
    public VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(virtualizationType);
    }

    /**
     * <p>
     * The virtualization type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeString}.
     * </p>
     * 
     * @return The virtualization type of the instance.
     * @see VirtualizationType
     */
    public String virtualizationTypeString() {
        return virtualizationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amiLaunchIndex());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(platformString());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(architectureString());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorString());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(instanceLifecycleString());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(amiLaunchIndex(), other.amiLaunchIndex()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceTypeString(), other.instanceTypeString())
                && Objects.equals(kernelId(), other.kernelId()) && Objects.equals(keyName(), other.keyName())
                && Objects.equals(launchTime(), other.launchTime()) && Objects.equals(monitoring(), other.monitoring())
                && Objects.equals(placement(), other.placement()) && Objects.equals(platformString(), other.platformString())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(productCodes(), other.productCodes()) && Objects.equals(publicDnsName(), other.publicDnsName())
                && Objects.equals(publicIpAddress(), other.publicIpAddress()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(state(), other.state())
                && Objects.equals(stateTransitionReason(), other.stateTransitionReason())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(architectureString(), other.architectureString())
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(enaSupport(), other.enaSupport())
                && Objects.equals(hypervisorString(), other.hypervisorString())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(instanceLifecycleString(), other.instanceLifecycleString())
                && Objects.equals(elasticGpuAssociations(), other.elasticGpuAssociations())
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(rootDeviceName(), other.rootDeviceName())
                && Objects.equals(rootDeviceTypeString(), other.rootDeviceTypeString())
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(spotInstanceRequestId(), other.spotInstanceRequestId())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(tags(), other.tags())
                && Objects.equals(virtualizationTypeString(), other.virtualizationTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (amiLaunchIndex() != null) {
            sb.append("AmiLaunchIndex: ").append(amiLaunchIndex()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceTypeString() != null) {
            sb.append("InstanceType: ").append(instanceTypeString()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (keyName() != null) {
            sb.append("KeyName: ").append(keyName()).append(",");
        }
        if (launchTime() != null) {
            sb.append("LaunchTime: ").append(launchTime()).append(",");
        }
        if (monitoring() != null) {
            sb.append("Monitoring: ").append(monitoring()).append(",");
        }
        if (placement() != null) {
            sb.append("Placement: ").append(placement()).append(",");
        }
        if (platformString() != null) {
            sb.append("Platform: ").append(platformString()).append(",");
        }
        if (privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(privateDnsName()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (publicDnsName() != null) {
            sb.append("PublicDnsName: ").append(publicDnsName()).append(",");
        }
        if (publicIpAddress() != null) {
            sb.append("PublicIpAddress: ").append(publicIpAddress()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (stateTransitionReason() != null) {
            sb.append("StateTransitionReason: ").append(stateTransitionReason()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (architectureString() != null) {
            sb.append("Architecture: ").append(architectureString()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (enaSupport() != null) {
            sb.append("EnaSupport: ").append(enaSupport()).append(",");
        }
        if (hypervisorString() != null) {
            sb.append("Hypervisor: ").append(hypervisorString()).append(",");
        }
        if (iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(iamInstanceProfile()).append(",");
        }
        if (instanceLifecycleString() != null) {
            sb.append("InstanceLifecycle: ").append(instanceLifecycleString()).append(",");
        }
        if (elasticGpuAssociations() != null) {
            sb.append("ElasticGpuAssociations: ").append(elasticGpuAssociations()).append(",");
        }
        if (networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(networkInterfaces()).append(",");
        }
        if (rootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(rootDeviceName()).append(",");
        }
        if (rootDeviceTypeString() != null) {
            sb.append("RootDeviceType: ").append(rootDeviceTypeString()).append(",");
        }
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        if (sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(sourceDestCheck()).append(",");
        }
        if (spotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: ").append(spotInstanceRequestId()).append(",");
        }
        if (sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(sriovNetSupport()).append(",");
        }
        if (stateReason() != null) {
            sb.append("StateReason: ").append(stateReason()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (virtualizationTypeString() != null) {
            sb.append("VirtualizationType: ").append(virtualizationTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmiLaunchIndex":
            return Optional.of(clazz.cast(amiLaunchIndex()));
        case "ImageId":
            return Optional.of(clazz.cast(imageId()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceTypeString()));
        case "KernelId":
            return Optional.of(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.of(clazz.cast(keyName()));
        case "LaunchTime":
            return Optional.of(clazz.cast(launchTime()));
        case "Monitoring":
            return Optional.of(clazz.cast(monitoring()));
        case "Placement":
            return Optional.of(clazz.cast(placement()));
        case "Platform":
            return Optional.of(clazz.cast(platformString()));
        case "PrivateDnsName":
            return Optional.of(clazz.cast(privateDnsName()));
        case "PrivateIpAddress":
            return Optional.of(clazz.cast(privateIpAddress()));
        case "ProductCodes":
            return Optional.of(clazz.cast(productCodes()));
        case "PublicDnsName":
            return Optional.of(clazz.cast(publicDnsName()));
        case "PublicIpAddress":
            return Optional.of(clazz.cast(publicIpAddress()));
        case "RamdiskId":
            return Optional.of(clazz.cast(ramdiskId()));
        case "State":
            return Optional.of(clazz.cast(state()));
        case "StateTransitionReason":
            return Optional.of(clazz.cast(stateTransitionReason()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        case "Architecture":
            return Optional.of(clazz.cast(architectureString()));
        case "BlockDeviceMappings":
            return Optional.of(clazz.cast(blockDeviceMappings()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "EbsOptimized":
            return Optional.of(clazz.cast(ebsOptimized()));
        case "EnaSupport":
            return Optional.of(clazz.cast(enaSupport()));
        case "Hypervisor":
            return Optional.of(clazz.cast(hypervisorString()));
        case "IamInstanceProfile":
            return Optional.of(clazz.cast(iamInstanceProfile()));
        case "InstanceLifecycle":
            return Optional.of(clazz.cast(instanceLifecycleString()));
        case "ElasticGpuAssociations":
            return Optional.of(clazz.cast(elasticGpuAssociations()));
        case "NetworkInterfaces":
            return Optional.of(clazz.cast(networkInterfaces()));
        case "RootDeviceName":
            return Optional.of(clazz.cast(rootDeviceName()));
        case "RootDeviceType":
            return Optional.of(clazz.cast(rootDeviceTypeString()));
        case "SecurityGroups":
            return Optional.of(clazz.cast(securityGroups()));
        case "SourceDestCheck":
            return Optional.of(clazz.cast(sourceDestCheck()));
        case "SpotInstanceRequestId":
            return Optional.of(clazz.cast(spotInstanceRequestId()));
        case "SriovNetSupport":
            return Optional.of(clazz.cast(sriovNetSupport()));
        case "StateReason":
            return Optional.of(clazz.cast(stateReason()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "VirtualizationType":
            return Optional.of(clazz.cast(virtualizationTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The AMI launch index, which can be used to find this instance in the launch group.
         * </p>
         * 
         * @param amiLaunchIndex
         *        The AMI launch index, which can be used to find this instance in the launch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiLaunchIndex(Integer amiLaunchIndex);

        /**
         * <p>
         * The ID of the AMI used to launch the instance.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The kernel associated with this instance, if applicable.
         * </p>
         * 
         * @param kernelId
         *        The kernel associated with this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair, if this instance was launched with an associated key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair, if this instance was launched with an associated key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The time the instance was launched.
         * </p>
         * 
         * @param launchTime
         *        The time the instance was launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(Monitoring monitoring);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link Monitoring.Builder} avoiding the need to create
         * one manually via {@link Monitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link Monitoring.Builder#build()} is called immediately and its result
         * is passed to {@link #monitoring(Monitoring)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link Monitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(Monitoring)
         */
        default Builder monitoring(Consumer<Monitoring.Builder> monitoring) {
            return monitoring(Monitoring.builder().apply(monitoring).build());
        }

        /**
         * <p>
         * The location where the instance launched, if applicable.
         * </p>
         * 
         * @param placement
         *        The location where the instance launched, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(Placement placement);

        /**
         * <p>
         * The location where the instance launched, if applicable.
         * </p>
         * This is a convenience that creates an instance of the {@link Placement.Builder} avoiding the need to create
         * one manually via {@link Placement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Placement.Builder#build()} is called immediately and its result
         * is passed to {@link #placement(Placement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link Placement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(Placement)
         */
        default Builder placement(Consumer<Placement.Builder> placement) {
            return placement(Placement.builder().apply(placement).build());
        }

        /**
         * <p>
         * The value is <code>Windows</code> for Windows instances; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows instances; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The value is <code>Windows</code> for Windows instances; otherwise blank.
         * </p>
         * 
         * @param platform
         *        The value is <code>Windows</code> for Windows instances; otherwise blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside
         * the Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state.
         * </p>
         * <p>
         * [EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS
         * resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC,
         * your custom domain name servers must resolve the hostname as appropriate.
         * </p>
         * 
         * @param privateDnsName
         *        (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used
         *        inside the Amazon EC2 network. This name is not available until the instance enters the
         *        <code>running</code> state. </p>
         *        <p>
         *        [EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've
         *        enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS
         *        server in your VPC, your custom domain name servers must resolve the hostname as appropriate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The private IPv4 address assigned to the instance.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * 
         * @param productCodes
         *        The product codes attached to this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes attached to this instance, if applicable.
         * </p>
         * 
         * @param productCodes
         *        The product codes attached to this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance
         * enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS
         * hostnames for your VPC.
         * </p>
         * 
         * @param publicDnsName
         *        (IPv4 only) The public DNS name assigned to the instance. This name is not available until the
         *        instance enters the <code>running</code> state. For EC2-VPC, this name is only available if you've
         *        enabled DNS hostnames for your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The public IPv4 address assigned to the instance, if applicable.
         * </p>
         * 
         * @param publicIpAddress
         *        The public IPv4 address assigned to the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);

        /**
         * <p>
         * The RAM disk associated with this instance, if applicable.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk associated with this instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param state
         *        The current state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceState.Builder} avoiding the need to
         * create one manually via {@link InstanceState#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(InstanceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(InstanceState)
         */
        default Builder state(Consumer<InstanceState.Builder> state) {
            return state(InstanceState.builder().apply(state).build());
        }

        /**
         * <p>
         * The reason for the most recent state transition. This might be an empty string.
         * </p>
         * 
         * @param stateTransitionReason
         *        The reason for the most recent state transition. This might be an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionReason(String stateTransitionReason);

        /**
         * <p>
         * [EC2-VPC] The ID of the subnet in which the instance is running.
         * </p>
         * 
         * @param subnetId
         *        [EC2-VPC] The ID of the subnet in which the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * [EC2-VPC] The ID of the VPC in which the instance is running.
         * </p>
         * 
         * @param vpcId
         *        [EC2-VPC] The ID of the VPC in which the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The idempotency token you provided when you launched the instance, if applicable.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token you provided when you launched the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         * throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
         * optimization isn't available with all instance types. Additional usage charges apply when using an EBS
         * Optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
         *        optimization isn't available with all instance types. Additional usage charges apply when using an EBS
         *        Optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Specifies whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Specifies whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * The hypervisor type of the instance.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the instance.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The hypervisor type of the instance.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the instance.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(HypervisorType hypervisor);

        /**
         * <p>
         * The IAM instance profile associated with the instance, if applicable.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile associated with the instance, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile associated with the instance, if applicable.
         * </p>
         * This is a convenience that creates an instance of the {@link IamInstanceProfile.Builder} avoiding the need to
         * create one manually via {@link IamInstanceProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link IamInstanceProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #iamInstanceProfile(IamInstanceProfile)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfile)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfile.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfile.builder().apply(iamInstanceProfile).build());
        }

        /**
         * <p>
         * Indicates whether this is a Spot Instance or a Scheduled Instance.
         * </p>
         * 
         * @param instanceLifecycle
         *        Indicates whether this is a Spot Instance or a Scheduled Instance.
         * @see InstanceLifecycleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycleType
         */
        Builder instanceLifecycle(String instanceLifecycle);

        /**
         * <p>
         * Indicates whether this is a Spot Instance or a Scheduled Instance.
         * </p>
         * 
         * @param instanceLifecycle
         *        Indicates whether this is a Spot Instance or a Scheduled Instance.
         * @see InstanceLifecycleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceLifecycleType
         */
        Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle);

        /**
         * <p>
         * The Elastic GPU associated with the instance.
         * </p>
         * 
         * @param elasticGpuAssociations
         *        The Elastic GPU associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociations(Collection<ElasticGpuAssociation> elasticGpuAssociations);

        /**
         * <p>
         * The Elastic GPU associated with the instance.
         * </p>
         * 
         * @param elasticGpuAssociations
         *        The Elastic GPU associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociations(ElasticGpuAssociation... elasticGpuAssociations);

        /**
         * <p>
         * [EC2-VPC] One or more network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        [EC2-VPC] One or more network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces);

        /**
         * <p>
         * [EC2-VPC] One or more network interfaces for the instance.
         * </p>
         * 
         * @param networkInterfaces
         *        [EC2-VPC] One or more network interfaces for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterface... networkInterfaces);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(DeviceType rootDeviceType);

        /**
         * <p>
         * One or more security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<GroupIdentifier> securityGroups);

        /**
         * <p>
         * One or more security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        One or more security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(GroupIdentifier... securityGroups);

        /**
         * <p>
         * Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
         * source/destination checking is enabled on the instance. A value of <code>true</code> means that checking is
         * enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the
         * instance to perform NAT. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the
         * <i>Amazon Virtual Private Cloud User Guide</i>.
         * </p>
         * 
         * @param sourceDestCheck
         *        Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether
         *        source/destination checking is enabled on the instance. A value of <code>true</code> means that
         *        checking is enabled, and <code>false</code> means that checking is disabled. The value must be
         *        <code>false</code> for the instance to perform NAT. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a>
         *        in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * If the request is a Spot Instance request, the ID of the request.
         * </p>
         * 
         * @param spotInstanceRequestId
         *        If the request is a Spot Instance request, the ID of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestId(String spotInstanceRequestId);

        /**
         * <p>
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The reason for the most recent state transition.
         * </p>
         * 
         * @param stateReason
         *        The reason for the most recent state transition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(StateReason stateReason);

        /**
         * <p>
         * The reason for the most recent state transition.
         * </p>
         * This is a convenience that creates an instance of the {@link StateReason.Builder} avoiding the need to create
         * one manually via {@link StateReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link StateReason.Builder#build()} is called immediately and its result
         * is passed to {@link #stateReason(StateReason)}.
         * 
         * @param stateReason
         *        a consumer that will call methods on {@link StateReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateReason(StateReason)
         */
        default Builder stateReason(Consumer<StateReason.Builder> stateReason) {
            return stateReason(StateReason.builder().apply(stateReason).build());
        }

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the instance.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The virtualization type of the instance.
         * </p>
         * 
         * @param virtualizationType
         *        The virtualization type of the instance.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The virtualization type of the instance.
         * </p>
         * 
         * @param virtualizationType
         *        The virtualization type of the instance.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(VirtualizationType virtualizationType);
    }

    static final class BuilderImpl implements Builder {
        private Integer amiLaunchIndex;

        private String imageId;

        private String instanceId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private Instant launchTime;

        private Monitoring monitoring;

        private Placement placement;

        private String platform;

        private String privateDnsName;

        private String privateIpAddress;

        private List<ProductCode> productCodes;

        private String publicDnsName;

        private String publicIpAddress;

        private String ramdiskId;

        private InstanceState state;

        private String stateTransitionReason;

        private String subnetId;

        private String vpcId;

        private String architecture;

        private List<InstanceBlockDeviceMapping> blockDeviceMappings;

        private String clientToken;

        private Boolean ebsOptimized;

        private Boolean enaSupport;

        private String hypervisor;

        private IamInstanceProfile iamInstanceProfile;

        private String instanceLifecycle;

        private List<ElasticGpuAssociation> elasticGpuAssociations;

        private List<InstanceNetworkInterface> networkInterfaces;

        private String rootDeviceName;

        private String rootDeviceType;

        private List<GroupIdentifier> securityGroups;

        private Boolean sourceDestCheck;

        private String spotInstanceRequestId;

        private String sriovNetSupport;

        private StateReason stateReason;

        private List<Tag> tags;

        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            amiLaunchIndex(model.amiLaunchIndex);
            imageId(model.imageId);
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            keyName(model.keyName);
            launchTime(model.launchTime);
            monitoring(model.monitoring);
            placement(model.placement);
            platform(model.platform);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
            productCodes(model.productCodes);
            publicDnsName(model.publicDnsName);
            publicIpAddress(model.publicIpAddress);
            ramdiskId(model.ramdiskId);
            state(model.state);
            stateTransitionReason(model.stateTransitionReason);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            architecture(model.architecture);
            blockDeviceMappings(model.blockDeviceMappings);
            clientToken(model.clientToken);
            ebsOptimized(model.ebsOptimized);
            enaSupport(model.enaSupport);
            hypervisor(model.hypervisor);
            iamInstanceProfile(model.iamInstanceProfile);
            instanceLifecycle(model.instanceLifecycle);
            elasticGpuAssociations(model.elasticGpuAssociations);
            networkInterfaces(model.networkInterfaces);
            rootDeviceName(model.rootDeviceName);
            rootDeviceType(model.rootDeviceType);
            securityGroups(model.securityGroups);
            sourceDestCheck(model.sourceDestCheck);
            spotInstanceRequestId(model.spotInstanceRequestId);
            sriovNetSupport(model.sriovNetSupport);
            stateReason(model.stateReason);
            tags(model.tags);
            virtualizationType(model.virtualizationType);
        }

        public final Integer getAmiLaunchIndex() {
            return amiLaunchIndex;
        }

        @Override
        public final Builder amiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this;
        }

        public final void setAmiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        public final Monitoring.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Monitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final Placement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final InstanceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getStateTransitionReason() {
            return stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Collection<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(InstanceBlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor.toString());
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getInstanceLifecycle() {
            return instanceLifecycle;
        }

        @Override
        public final Builder instanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
            return this;
        }

        @Override
        public final Builder instanceLifecycle(InstanceLifecycleType instanceLifecycle) {
            this.instanceLifecycle(instanceLifecycle.toString());
            return this;
        }

        public final void setInstanceLifecycle(String instanceLifecycle) {
            this.instanceLifecycle = instanceLifecycle;
        }

        public final Collection<ElasticGpuAssociation.Builder> getElasticGpuAssociations() {
            return elasticGpuAssociations != null ? elasticGpuAssociations.stream().map(ElasticGpuAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuAssociations(Collection<ElasticGpuAssociation> elasticGpuAssociations) {
            this.elasticGpuAssociations = ElasticGpuAssociationListCopier.copy(elasticGpuAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuAssociations(ElasticGpuAssociation... elasticGpuAssociations) {
            elasticGpuAssociations(Arrays.asList(elasticGpuAssociations));
            return this;
        }

        public final void setElasticGpuAssociations(Collection<ElasticGpuAssociation.BuilderImpl> elasticGpuAssociations) {
            this.elasticGpuAssociations = ElasticGpuAssociationListCopier.copyFromBuilder(elasticGpuAssociations);
        }

        public final Collection<InstanceNetworkInterface.Builder> getNetworkInterfaces() {
            return networkInterfaces != null ? networkInterfaces.stream().map(InstanceNetworkInterface::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterface> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getRootDeviceType() {
            return rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final Collection<GroupIdentifier.Builder> getSecurityGroups() {
            return securityGroups != null ? securityGroups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder securityGroups(Collection<GroupIdentifier> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(GroupIdentifier... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<GroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = GroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getSpotInstanceRequestId() {
            return spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final StateReason.Builder getStateReason() {
            return stateReason != null ? stateReason.toBuilder() : null;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(StateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }
    }
}
