/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the launch specification for VM import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportInstanceLaunchSpecification implements
        ToCopyableBuilder<ImportInstanceLaunchSpecification.Builder, ImportInstanceLaunchSpecification> {
    private final String additionalInfo;

    private final String architecture;

    private final List<String> groupIds;

    private final List<String> groupNames;

    private final String instanceInitiatedShutdownBehavior;

    private final String instanceType;

    private final Boolean monitoring;

    private final Placement placement;

    private final String privateIpAddress;

    private final String subnetId;

    private final UserData userData;

    private ImportInstanceLaunchSpecification(BuilderImpl builder) {
        this.additionalInfo = builder.additionalInfo;
        this.architecture = builder.architecture;
        this.groupIds = builder.groupIds;
        this.groupNames = builder.groupNames;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.privateIpAddress = builder.privateIpAddress;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public String additionalInfo() {
        return additionalInfo;
    }

    /**
     * <p>
     * The architecture of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureString}.
     * </p>
     * 
     * @return The architecture of the instance.
     * @see ArchitectureValues
     */
    public ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(architecture);
    }

    /**
     * <p>
     * The architecture of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureString}.
     * </p>
     * 
     * @return The architecture of the instance.
     * @see ArchitectureValues
     */
    public String architectureString() {
        return architecture;
    }

    /**
     * <p>
     * One or more security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group IDs.
     */
    public List<String> groupIds() {
        return groupIds;
    }

    /**
     * <p>
     * One or more security group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group names.
     */
    public List<String> groupNames() {
        return groupNames;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     * @see ShutdownBehavior
     */
    public ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(instanceInitiatedShutdownBehavior);
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     * @see ShutdownBehavior
     */
    public String instanceInitiatedShutdownBehaviorString() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * The instance type. For more information about the instance types that you can import, see <a
     * href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
     * >Instance Types</a> in the VM Import/Export User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type. For more information about the instance types that you can import, see <a
     *         href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
     *         >Instance Types</a> in the VM Import/Export User Guide.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type. For more information about the instance types that you can import, see <a
     * href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
     * >Instance Types</a> in the VM Import/Export User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type. For more information about the instance types that you can import, see <a
     *         href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
     *         >Instance Types</a> in the VM Import/Export User Guide.
     * @see InstanceType
     */
    public String instanceTypeString() {
        return instanceType;
    }

    /**
     * <p>
     * Indicates whether monitoring is enabled.
     * </p>
     * 
     * @return Indicates whether monitoring is enabled.
     */
    public Boolean monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The placement information for the instance.
     * </p>
     * 
     * @return The placement information for the instance.
     */
    public Placement placement() {
        return placement;
    }

    /**
     * <p>
     * [EC2-VPC] An available IP address from the IP address range of the subnet.
     * </p>
     * 
     * @return [EC2-VPC] An available IP address from the IP address range of the subnet.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the subnet in which to launch the instance.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the subnet in which to launch the instance.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The user data to make available to the instance. If you are using an AWS SDK or command line tool,
     * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
     * Base64-encoded text.
     * </p>
     * 
     * @return The user data to make available to the instance. If you are using an AWS SDK or command line tool,
     *         Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
     *         Base64-encoded text.
     */
    public UserData userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(architectureString());
        hashCode = 31 * hashCode + Objects.hashCode(groupIds());
        hashCode = 31 * hashCode + Objects.hashCode(groupNames());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehaviorString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceLaunchSpecification)) {
            return false;
        }
        ImportInstanceLaunchSpecification other = (ImportInstanceLaunchSpecification) obj;
        return Objects.equals(additionalInfo(), other.additionalInfo())
                && Objects.equals(architectureString(), other.architectureString())
                && Objects.equals(groupIds(), other.groupIds()) && Objects.equals(groupNames(), other.groupNames())
                && Objects.equals(instanceInitiatedShutdownBehaviorString(), other.instanceInitiatedShutdownBehaviorString())
                && Objects.equals(instanceTypeString(), other.instanceTypeString())
                && Objects.equals(monitoring(), other.monitoring()) && Objects.equals(placement(), other.placement())
                && Objects.equals(privateIpAddress(), other.privateIpAddress()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(userData(), other.userData());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(additionalInfo()).append(",");
        }
        if (architectureString() != null) {
            sb.append("Architecture: ").append(architectureString()).append(",");
        }
        if (groupIds() != null) {
            sb.append("GroupIds: ").append(groupIds()).append(",");
        }
        if (groupNames() != null) {
            sb.append("GroupNames: ").append(groupNames()).append(",");
        }
        if (instanceInitiatedShutdownBehaviorString() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(instanceInitiatedShutdownBehaviorString()).append(",");
        }
        if (instanceTypeString() != null) {
            sb.append("InstanceType: ").append(instanceTypeString()).append(",");
        }
        if (monitoring() != null) {
            sb.append("Monitoring: ").append(monitoring()).append(",");
        }
        if (placement() != null) {
            sb.append("Placement: ").append(placement()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalInfo":
            return Optional.of(clazz.cast(additionalInfo()));
        case "Architecture":
            return Optional.of(clazz.cast(architectureString()));
        case "GroupIds":
            return Optional.of(clazz.cast(groupIds()));
        case "GroupNames":
            return Optional.of(clazz.cast(groupNames()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.of(clazz.cast(instanceInitiatedShutdownBehaviorString()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceTypeString()));
        case "Monitoring":
            return Optional.of(clazz.cast(monitoring()));
        case "Placement":
            return Optional.of(clazz.cast(placement()));
        case "PrivateIpAddress":
            return Optional.of(clazz.cast(privateIpAddress()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        case "UserData":
            return Optional.of(clazz.cast(userData()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ImportInstanceLaunchSpecification> {
        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param additionalInfo
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);

        /**
         * <p>
         * The architecture of the instance.
         * </p>
         * 
         * @param architecture
         *        The architecture of the instance.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the instance.
         * </p>
         * 
         * @param architecture
         *        The architecture of the instance.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * One or more security group IDs.
         * </p>
         * 
         * @param groupIds
         *        One or more security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(Collection<String> groupIds);

        /**
         * <p>
         * One or more security group IDs.
         * </p>
         * 
         * @param groupIds
         *        One or more security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(String... groupIds);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param groupNames
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param groupNames
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * The instance type. For more information about the instance types that you can import, see <a href=
         * "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
         * >Instance Types</a> in the VM Import/Export User Guide.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information about the instance types that you can import, see <a href=
         *        "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
         *        >Instance Types</a> in the VM Import/Export User Guide.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. For more information about the instance types that you can import, see <a href=
         * "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
         * >Instance Types</a> in the VM Import/Export User Guide.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information about the instance types that you can import, see <a href=
         *        "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
         *        >Instance Types</a> in the VM Import/Export User Guide.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * Indicates whether monitoring is enabled.
         * </p>
         * 
         * @param monitoring
         *        Indicates whether monitoring is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(Boolean monitoring);

        /**
         * <p>
         * The placement information for the instance.
         * </p>
         * 
         * @param placement
         *        The placement information for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(Placement placement);

        /**
         * <p>
         * The placement information for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link Placement.Builder} avoiding the need to create
         * one manually via {@link Placement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Placement.Builder#build()} is called immediately and its result
         * is passed to {@link #placement(Placement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link Placement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(Placement)
         */
        default Builder placement(Consumer<Placement.Builder> placement) {
            return placement(Placement.builder().apply(placement).build());
        }

        /**
         * <p>
         * [EC2-VPC] An available IP address from the IP address range of the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        [EC2-VPC] An available IP address from the IP address range of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * [EC2-VPC] The ID of the subnet in which to launch the instance.
         * </p>
         * 
         * @param subnetId
         *        [EC2-VPC] The ID of the subnet in which to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The user data to make available to the instance. If you are using an AWS SDK or command line tool,
         * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
         * Base64-encoded text.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the instance. If you are using an AWS SDK or command line tool,
         *        Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must
         *        provide Base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(UserData userData);

        /**
         * <p>
         * The user data to make available to the instance. If you are using an AWS SDK or command line tool,
         * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
         * Base64-encoded text.
         * </p>
         * This is a convenience that creates an instance of the {@link UserData.Builder} avoiding the need to create
         * one manually via {@link UserData#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserData.Builder#build()} is called immediately and its result is
         * passed to {@link #userData(UserData)}.
         * 
         * @param userData
         *        a consumer that will call methods on {@link UserData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userData(UserData)
         */
        default Builder userData(Consumer<UserData.Builder> userData) {
            return userData(UserData.builder().apply(userData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String additionalInfo;

        private String architecture;

        private List<String> groupIds;

        private List<String> groupNames;

        private String instanceInitiatedShutdownBehavior;

        private String instanceType;

        private Boolean monitoring;

        private Placement placement;

        private String privateIpAddress;

        private String subnetId;

        private UserData userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceLaunchSpecification model) {
            additionalInfo(model.additionalInfo);
            architecture(model.architecture);
            groupIds(model.groupIds);
            groupNames(model.groupNames);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            instanceType(model.instanceType);
            monitoring(model.monitoring);
            placement(model.placement);
            privateIpAddress(model.privateIpAddress);
            subnetId(model.subnetId);
            userData(model.userData);
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Collection<String> getGroupIds() {
            return groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String... groupIds) {
            groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
        }

        public final Collection<String> getGroupNames() {
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Boolean getMonitoring() {
            return monitoring;
        }

        @Override
        public final Builder monitoring(Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Boolean monitoring) {
            this.monitoring = monitoring;
        }

        public final Placement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final UserData.Builder getUserData() {
            return userData != null ? userData.toBuilder() : null;
        }

        @Override
        public final Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(UserData.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        @Override
        public ImportInstanceLaunchSpecification build() {
            return new ImportInstanceLaunchSpecification(this);
        }
    }
}
