/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpcs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeVpcsResponse.Builder, DescribeVpcsResponse> {
    private final List<Vpc> vpcs;

    private DescribeVpcsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcs = builder.vpcs;
    }

    /**
     * <p>
     * Information about one or more VPCs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more VPCs.
     */
    public List<Vpc> vpcs() {
        return vpcs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcsResponse)) {
            return false;
        }
        DescribeVpcsResponse other = (DescribeVpcsResponse) obj;
        return Objects.equals(vpcs(), other.vpcs());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (vpcs() != null) {
            sb.append("Vpcs: ").append(vpcs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vpcs":
            return Optional.of(clazz.cast(vpcs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeVpcsResponse> {
        /**
         * <p>
         * Information about one or more VPCs.
         * </p>
         * 
         * @param vpcs
         *        Information about one or more VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(Collection<Vpc> vpcs);

        /**
         * <p>
         * Information about one or more VPCs.
         * </p>
         * 
         * @param vpcs
         *        Information about one or more VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(Vpc... vpcs);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<Vpc> vpcs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcsResponse model) {
            vpcs(model.vpcs);
        }

        public final Collection<Vpc.Builder> getVpcs() {
            return vpcs != null ? vpcs.stream().map(Vpc::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcs(Collection<Vpc> vpcs) {
            this.vpcs = VpcListCopier.copy(vpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(Vpc... vpcs) {
            vpcs(Arrays.asList(vpcs));
            return this;
        }

        public final void setVpcs(Collection<Vpc.BuilderImpl> vpcs) {
            this.vpcs = VpcListCopier.copyFromBuilder(vpcs);
        }

        @Override
        public DescribeVpcsResponse build() {
            return new DescribeVpcsResponse(this);
        }
    }
}
