/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumesModificationsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeVolumesModificationsResponse.Builder, DescribeVolumesModificationsResponse> {
    private final List<VolumeModification> volumesModifications;

    private final String nextToken;

    private DescribeVolumesModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.volumesModifications = builder.volumesModifications;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of returned <a>VolumeModification</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of returned <a>VolumeModification</a> objects.
     */
    public List<VolumeModification> volumesModifications() {
        return volumesModifications;
    }

    /**
     * <p>
     * Token for pagination, null if there are no more results
     * </p>
     * 
     * @return Token for pagination, null if there are no more results
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumesModifications());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesModificationsResponse)) {
            return false;
        }
        DescribeVolumesModificationsResponse other = (DescribeVolumesModificationsResponse) obj;
        return Objects.equals(volumesModifications(), other.volumesModifications())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (volumesModifications() != null) {
            sb.append("VolumesModifications: ").append(volumesModifications()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumesModifications":
            return Optional.of(clazz.cast(volumesModifications()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeVolumesModificationsResponse> {
        /**
         * <p>
         * A list of returned <a>VolumeModification</a> objects.
         * </p>
         * 
         * @param volumesModifications
         *        A list of returned <a>VolumeModification</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesModifications(Collection<VolumeModification> volumesModifications);

        /**
         * <p>
         * A list of returned <a>VolumeModification</a> objects.
         * </p>
         * 
         * @param volumesModifications
         *        A list of returned <a>VolumeModification</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumesModifications(VolumeModification... volumesModifications);

        /**
         * <p>
         * Token for pagination, null if there are no more results
         * </p>
         * 
         * @param nextToken
         *        Token for pagination, null if there are no more results
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<VolumeModification> volumesModifications;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesModificationsResponse model) {
            volumesModifications(model.volumesModifications);
            nextToken(model.nextToken);
        }

        public final Collection<VolumeModification.Builder> getVolumesModifications() {
            return volumesModifications != null ? volumesModifications.stream().map(VolumeModification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumesModifications(Collection<VolumeModification> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copy(volumesModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesModifications(VolumeModification... volumesModifications) {
            volumesModifications(Arrays.asList(volumesModifications));
            return this;
        }

        public final void setVolumesModifications(Collection<VolumeModification.BuilderImpl> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copyFromBuilder(volumesModifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVolumesModificationsResponse build() {
            return new DescribeVolumesModificationsResponse(this);
        }
    }
}
