/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotFleetRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSpotFleetRequestsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeSpotFleetRequestsResponse.Builder, DescribeSpotFleetRequestsResponse> {
    private final String nextToken;

    private final List<SpotFleetRequestConfig> spotFleetRequestConfigs;

    private DescribeSpotFleetRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.spotFleetRequestConfigs = builder.spotFleetRequestConfigs;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about the configuration of your Spot fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the configuration of your Spot fleet.
     */
    public List<SpotFleetRequestConfig> spotFleetRequestConfigs() {
        return spotFleetRequestConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestConfigs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestsResponse)) {
            return false;
        }
        DescribeSpotFleetRequestsResponse other = (DescribeSpotFleetRequestsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(spotFleetRequestConfigs(), other.spotFleetRequestConfigs());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (spotFleetRequestConfigs() != null) {
            sb.append("SpotFleetRequestConfigs: ").append(spotFleetRequestConfigs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "SpotFleetRequestConfigs":
            return Optional.of(clazz.cast(spotFleetRequestConfigs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeSpotFleetRequestsResponse> {
        /**
         * <p>
         * The token required to retrieve the next set of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the configuration of your Spot fleet.
         * </p>
         * 
         * @param spotFleetRequestConfigs
         *        Information about the configuration of your Spot fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfigs(Collection<SpotFleetRequestConfig> spotFleetRequestConfigs);

        /**
         * <p>
         * Information about the configuration of your Spot fleet.
         * </p>
         * 
         * @param spotFleetRequestConfigs
         *        Information about the configuration of your Spot fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfigs(SpotFleetRequestConfig... spotFleetRequestConfigs);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<SpotFleetRequestConfig> spotFleetRequestConfigs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestsResponse model) {
            nextToken(model.nextToken);
            spotFleetRequestConfigs(model.spotFleetRequestConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SpotFleetRequestConfig.Builder> getSpotFleetRequestConfigs() {
            return spotFleetRequestConfigs != null ? spotFleetRequestConfigs.stream().map(SpotFleetRequestConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder spotFleetRequestConfigs(Collection<SpotFleetRequestConfig> spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs = SpotFleetRequestConfigSetCopier.copy(spotFleetRequestConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestConfigs(SpotFleetRequestConfig... spotFleetRequestConfigs) {
            spotFleetRequestConfigs(Arrays.asList(spotFleetRequestConfigs));
            return this;
        }

        public final void setSpotFleetRequestConfigs(Collection<SpotFleetRequestConfig.BuilderImpl> spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs = SpotFleetRequestConfigSetCopier.copyFromBuilder(spotFleetRequestConfigs);
        }

        @Override
        public DescribeSpotFleetRequestsResponse build() {
            return new DescribeSpotFleetRequestsResponse(this);
        }
    }
}
