/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScheduledInstancesRequest extends EC2Request implements
        ToCopyableBuilder<DescribeScheduledInstancesRequest.Builder, DescribeScheduledInstancesRequest> {
    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> scheduledInstanceIds;

    private final SlotStartTimeRangeRequest slotStartTimeRange;

    private DescribeScheduledInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scheduledInstanceIds = builder.scheduledInstanceIds;
        this.slotStartTimeRange = builder.slotStartTimeRange;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. This value can be between 5 and 300. The default value
     * is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. This value can be between 5 and 300. The
     *         default value is 100. To retrieve the remaining results, make another call with the returned
     *         <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * One or more Scheduled Instance IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Scheduled Instance IDs.
     */
    public List<String> scheduledInstanceIds() {
        return scheduledInstanceIds;
    }

    /**
     * <p>
     * The time period for the first schedule to start.
     * </p>
     * 
     * @return The time period for the first schedule to start.
     */
    public SlotStartTimeRangeRequest slotStartTimeRange() {
        return slotStartTimeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledInstanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(slotStartTimeRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesRequest)) {
            return false;
        }
        DescribeScheduledInstancesRequest other = (DescribeScheduledInstancesRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(scheduledInstanceIds(), other.scheduledInstanceIds())
                && Objects.equals(slotStartTimeRange(), other.slotStartTimeRange());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (scheduledInstanceIds() != null) {
            sb.append("ScheduledInstanceIds: ").append(scheduledInstanceIds()).append(",");
        }
        if (slotStartTimeRange() != null) {
            sb.append("SlotStartTimeRange: ").append(slotStartTimeRange()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "ScheduledInstanceIds":
            return Optional.of(clazz.cast(scheduledInstanceIds()));
        case "SlotStartTimeRange":
            return Optional.of(clazz.cast(slotStartTimeRange()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeScheduledInstancesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The maximum number of results to return in a single call. This value can be between 5 and 300. The default
         * value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. This value can be between 5 and 300. The
         *        default value is 100. To retrieve the remaining results, make another call with the returned
         *        <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * One or more Scheduled Instance IDs.
         * </p>
         * 
         * @param scheduledInstanceIds
         *        One or more Scheduled Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceIds(Collection<String> scheduledInstanceIds);

        /**
         * <p>
         * One or more Scheduled Instance IDs.
         * </p>
         * 
         * @param scheduledInstanceIds
         *        One or more Scheduled Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceIds(String... scheduledInstanceIds);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * 
         * @param slotStartTimeRange
         *        The time period for the first schedule to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * This is a convenience that creates an instance of the {@link SlotStartTimeRangeRequest.Builder} avoiding the
         * need to create one manually via {@link SlotStartTimeRangeRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlotStartTimeRangeRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #slotStartTimeRange(SlotStartTimeRangeRequest)}.
         * 
         * @param slotStartTimeRange
         *        a consumer that will call methods on {@link SlotStartTimeRangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotStartTimeRange(SlotStartTimeRangeRequest)
         */
        default Builder slotStartTimeRange(Consumer<SlotStartTimeRangeRequest.Builder> slotStartTimeRange) {
            return slotStartTimeRange(SlotStartTimeRangeRequest.builder().apply(slotStartTimeRange).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private Integer maxResults;

        private String nextToken;

        private List<String> scheduledInstanceIds;

        private SlotStartTimeRangeRequest slotStartTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstancesRequest model) {
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            scheduledInstanceIds(model.scheduledInstanceIds);
            slotStartTimeRange(model.slotStartTimeRange);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getScheduledInstanceIds() {
            return scheduledInstanceIds;
        }

        @Override
        public final Builder scheduledInstanceIds(Collection<String> scheduledInstanceIds) {
            this.scheduledInstanceIds = ScheduledInstanceIdRequestSetCopier.copy(scheduledInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceIds(String... scheduledInstanceIds) {
            scheduledInstanceIds(Arrays.asList(scheduledInstanceIds));
            return this;
        }

        public final void setScheduledInstanceIds(Collection<String> scheduledInstanceIds) {
            this.scheduledInstanceIds = ScheduledInstanceIdRequestSetCopier.copy(scheduledInstanceIds);
        }

        public final SlotStartTimeRangeRequest.Builder getSlotStartTimeRange() {
            return slotStartTimeRange != null ? slotStartTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder slotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
            this.slotStartTimeRange = slotStartTimeRange;
            return this;
        }

        public final void setSlotStartTimeRange(SlotStartTimeRangeRequest.BuilderImpl slotStartTimeRange) {
            this.slotStartTimeRange = slotStartTimeRange != null ? slotStartTimeRange.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledInstancesRequest build() {
            return new DescribeScheduledInstancesRequest(this);
        }
    }
}
