/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeImportImageTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeImportImageTasksResponse extends EC2Response implements
        ToCopyableBuilder<DescribeImportImageTasksResponse.Builder, DescribeImportImageTasksResponse> {
    private final List<ImportImageTask> importImageTasks;

    private final String nextToken;

    private DescribeImportImageTasksResponse(BuilderImpl builder) {
        super(builder);
        this.importImageTasks = builder.importImageTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of zero or more import image tasks that are currently active or were completed or canceled in the previous
     * 7 days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of zero or more import image tasks that are currently active or were completed or canceled in the
     *         previous 7 days.
     */
    public List<ImportImageTask> importImageTasks() {
        return importImageTasks;
    }

    /**
     * <p>
     * The token to use to get the next page of results. This value is <code>null</code> when there are no more results
     * to return.
     * </p>
     * 
     * @return The token to use to get the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importImageTasks());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportImageTasksResponse)) {
            return false;
        }
        DescribeImportImageTasksResponse other = (DescribeImportImageTasksResponse) obj;
        return Objects.equals(importImageTasks(), other.importImageTasks()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (importImageTasks() != null) {
            sb.append("ImportImageTasks: ").append(importImageTasks()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportImageTasks":
            return Optional.of(clazz.cast(importImageTasks()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeImportImageTasksResponse> {
        /**
         * <p>
         * A list of zero or more import image tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importImageTasks
         *        A list of zero or more import image tasks that are currently active or were completed or canceled in
         *        the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importImageTasks(Collection<ImportImageTask> importImageTasks);

        /**
         * <p>
         * A list of zero or more import image tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importImageTasks
         *        A list of zero or more import image tasks that are currently active or were completed or canceled in
         *        the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importImageTasks(ImportImageTask... importImageTasks);

        /**
         * <p>
         * The token to use to get the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<ImportImageTask> importImageTasks;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportImageTasksResponse model) {
            importImageTasks(model.importImageTasks);
            nextToken(model.nextToken);
        }

        public final Collection<ImportImageTask.Builder> getImportImageTasks() {
            return importImageTasks != null ? importImageTasks.stream().map(ImportImageTask::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder importImageTasks(Collection<ImportImageTask> importImageTasks) {
            this.importImageTasks = ImportImageTaskListCopier.copy(importImageTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importImageTasks(ImportImageTask... importImageTasks) {
            importImageTasks(Arrays.asList(importImageTasks));
            return this;
        }

        public final void setImportImageTasks(Collection<ImportImageTask.BuilderImpl> importImageTasks) {
            this.importImageTasks = ImportImageTaskListCopier.copyFromBuilder(importImageTasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImportImageTasksResponse build() {
            return new DescribeImportImageTasksResponse(this);
        }
    }
}
