/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFpgaImageAttributeResponse extends EC2Response implements
        ToCopyableBuilder<DescribeFpgaImageAttributeResponse.Builder, DescribeFpgaImageAttributeResponse> {
    private final FpgaImageAttribute fpgaImageAttribute;

    private DescribeFpgaImageAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.fpgaImageAttribute = builder.fpgaImageAttribute;
    }

    /**
     * <p>
     * Information about the attribute.
     * </p>
     * 
     * @return Information about the attribute.
     */
    public FpgaImageAttribute fpgaImageAttribute() {
        return fpgaImageAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageAttribute());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImageAttributeResponse)) {
            return false;
        }
        DescribeFpgaImageAttributeResponse other = (DescribeFpgaImageAttributeResponse) obj;
        return Objects.equals(fpgaImageAttribute(), other.fpgaImageAttribute());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fpgaImageAttribute() != null) {
            sb.append("FpgaImageAttribute: ").append(fpgaImageAttribute()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageAttribute":
            return Optional.of(clazz.cast(fpgaImageAttribute()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeFpgaImageAttributeResponse> {
        /**
         * <p>
         * Information about the attribute.
         * </p>
         * 
         * @param fpgaImageAttribute
         *        Information about the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageAttribute(FpgaImageAttribute fpgaImageAttribute);

        /**
         * <p>
         * Information about the attribute.
         * </p>
         * This is a convenience that creates an instance of the {@link FpgaImageAttribute.Builder} avoiding the need to
         * create one manually via {@link FpgaImageAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link FpgaImageAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #fpgaImageAttribute(FpgaImageAttribute)}.
         * 
         * @param fpgaImageAttribute
         *        a consumer that will call methods on {@link FpgaImageAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fpgaImageAttribute(FpgaImageAttribute)
         */
        default Builder fpgaImageAttribute(Consumer<FpgaImageAttribute.Builder> fpgaImageAttribute) {
            return fpgaImageAttribute(FpgaImageAttribute.builder().apply(fpgaImageAttribute).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private FpgaImageAttribute fpgaImageAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImageAttributeResponse model) {
            fpgaImageAttribute(model.fpgaImageAttribute);
        }

        public final FpgaImageAttribute.Builder getFpgaImageAttribute() {
            return fpgaImageAttribute != null ? fpgaImageAttribute.toBuilder() : null;
        }

        @Override
        public final Builder fpgaImageAttribute(FpgaImageAttribute fpgaImageAttribute) {
            this.fpgaImageAttribute = fpgaImageAttribute;
            return this;
        }

        public final void setFpgaImageAttribute(FpgaImageAttribute.BuilderImpl fpgaImageAttribute) {
            this.fpgaImageAttribute = fpgaImageAttribute != null ? fpgaImageAttribute.build() : null;
        }

        @Override
        public DescribeFpgaImageAttributeResponse build() {
            return new DescribeFpgaImageAttributeResponse(this);
        }
    }
}
