/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeExportTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeExportTasksRequest extends EC2Request implements
        ToCopyableBuilder<DescribeExportTasksRequest.Builder, DescribeExportTasksRequest> {
    private final List<String> exportTaskIds;

    private DescribeExportTasksRequest(BuilderImpl builder) {
        super(builder);
        this.exportTaskIds = builder.exportTaskIds;
    }

    /**
     * <p>
     * One or more export task IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more export task IDs.
     */
    public List<String> exportTaskIds() {
        return exportTaskIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportTaskIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksRequest)) {
            return false;
        }
        DescribeExportTasksRequest other = (DescribeExportTasksRequest) obj;
        return Objects.equals(exportTaskIds(), other.exportTaskIds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (exportTaskIds() != null) {
            sb.append("ExportTaskIds: ").append(exportTaskIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportTaskIds":
            return Optional.of(clazz.cast(exportTaskIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeExportTasksRequest> {
        /**
         * <p>
         * One or more export task IDs.
         * </p>
         * 
         * @param exportTaskIds
         *        One or more export task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTaskIds(Collection<String> exportTaskIds);

        /**
         * <p>
         * One or more export task IDs.
         * </p>
         * 
         * @param exportTaskIds
         *        One or more export task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTaskIds(String... exportTaskIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> exportTaskIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksRequest model) {
            exportTaskIds(model.exportTaskIds);
        }

        public final Collection<String> getExportTaskIds() {
            return exportTaskIds;
        }

        @Override
        public final Builder exportTaskIds(Collection<String> exportTaskIds) {
            this.exportTaskIds = ExportTaskIdStringListCopier.copy(exportTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTaskIds(String... exportTaskIds) {
            exportTaskIds(Arrays.asList(exportTaskIds));
            return this;
        }

        public final void setExportTaskIds(Collection<String> exportTaskIds) {
            this.exportTaskIds = ExportTaskIdStringListCopier.copy(exportTaskIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeExportTasksRequest build() {
            return new DescribeExportTasksRequest(this);
        }
    }
}
