/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeElasticGpusRequest extends EC2Request implements
        ToCopyableBuilder<DescribeElasticGpusRequest.Builder, DescribeElasticGpusRequest> {
    private final List<String> elasticGpuIds;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeElasticGpusRequest(BuilderImpl builder) {
        super(builder);
        this.elasticGpuIds = builder.elasticGpuIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more Elastic GPU IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Elastic GPU IDs.
     */
    public List<String> elasticGpuIds() {
        return elasticGpuIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone in which the Elastic GPU resides.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elastic-gpu-health</code> - The status of the Elastic GPU (<code>OK</code> | <code>IMPAIRED</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elastic-gpu-state</code> - The state of the Elastic GPU (<code>ATTACHED</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elastic-gpu-type</code> - The type of Elastic GPU; for example, <code>eg1.medium</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance to which the Elastic GPU is associated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone in which the Elastic GPU resides.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elastic-gpu-health</code> - The status of the Elastic GPU (<code>OK</code> | <code>IMPAIRED</code>
     *         ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elastic-gpu-state</code> - The state of the Elastic GPU (<code>ATTACHED</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elastic-gpu-type</code> - The type of Elastic GPU; for example, <code>eg1.medium</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance to which the Elastic GPU is associated.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuIds());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticGpusRequest)) {
            return false;
        }
        DescribeElasticGpusRequest other = (DescribeElasticGpusRequest) obj;
        return Objects.equals(elasticGpuIds(), other.elasticGpuIds()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (elasticGpuIds() != null) {
            sb.append("ElasticGpuIds: ").append(elasticGpuIds()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticGpuIds":
            return Optional.of(clazz.cast(elasticGpuIds()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeElasticGpusRequest> {
        /**
         * <p>
         * One or more Elastic GPU IDs.
         * </p>
         * 
         * @param elasticGpuIds
         *        One or more Elastic GPU IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuIds(Collection<String> elasticGpuIds);

        /**
         * <p>
         * One or more Elastic GPU IDs.
         * </p>
         * 
         * @param elasticGpuIds
         *        One or more Elastic GPU IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuIds(String... elasticGpuIds);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the Elastic GPU resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-health</code> - The status of the Elastic GPU (<code>OK</code> | <code>IMPAIRED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-state</code> - The state of the Elastic GPU (<code>ATTACHED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-type</code> - The type of Elastic GPU; for example, <code>eg1.medium</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance to which the Elastic GPU is associated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the Elastic GPU resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-health</code> - The status of the Elastic GPU (<code>OK</code> |
         *        <code>IMPAIRED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-state</code> - The state of the Elastic GPU (<code>ATTACHED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-type</code> - The type of Elastic GPU; for example, <code>eg1.medium</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance to which the Elastic GPU is associated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the Elastic GPU resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-health</code> - The status of the Elastic GPU (<code>OK</code> | <code>IMPAIRED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-state</code> - The state of the Elastic GPU (<code>ATTACHED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-type</code> - The type of Elastic GPU; for example, <code>eg1.medium</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance to which the Elastic GPU is associated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the Elastic GPU resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-health</code> - The status of the Elastic GPU (<code>OK</code> |
         *        <code>IMPAIRED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-state</code> - The state of the Elastic GPU (<code>ATTACHED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-type</code> - The type of Elastic GPU; for example, <code>eg1.medium</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance to which the Elastic GPU is associated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> elasticGpuIds;

        private List<Filter> filters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticGpusRequest model) {
            elasticGpuIds(model.elasticGpuIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getElasticGpuIds() {
            return elasticGpuIds;
        }

        @Override
        public final Builder elasticGpuIds(Collection<String> elasticGpuIds) {
            this.elasticGpuIds = ElasticGpuIdSetCopier.copy(elasticGpuIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuIds(String... elasticGpuIds) {
            elasticGpuIds(Arrays.asList(elasticGpuIds));
            return this;
        }

        public final void setElasticGpuIds(Collection<String> elasticGpuIds) {
            this.elasticGpuIds = ElasticGpuIdSetCopier.copy(elasticGpuIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeElasticGpusRequest build() {
            return new DescribeElasticGpusRequest(this);
        }
    }
}
