/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeEgressOnlyInternetGatewaysResponse extends EC2Response implements
        ToCopyableBuilder<DescribeEgressOnlyInternetGatewaysResponse.Builder, DescribeEgressOnlyInternetGatewaysResponse> {
    private final List<EgressOnlyInternetGateway> egressOnlyInternetGateways;

    private final String nextToken;

    private DescribeEgressOnlyInternetGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.egressOnlyInternetGateways = builder.egressOnlyInternetGateways;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the egress-only Internet gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the egress-only Internet gateways.
     */
    public List<EgressOnlyInternetGateway> egressOnlyInternetGateways() {
        return egressOnlyInternetGateways;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGateways());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEgressOnlyInternetGatewaysResponse)) {
            return false;
        }
        DescribeEgressOnlyInternetGatewaysResponse other = (DescribeEgressOnlyInternetGatewaysResponse) obj;
        return Objects.equals(egressOnlyInternetGateways(), other.egressOnlyInternetGateways())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (egressOnlyInternetGateways() != null) {
            sb.append("EgressOnlyInternetGateways: ").append(egressOnlyInternetGateways()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressOnlyInternetGateways":
            return Optional.of(clazz.cast(egressOnlyInternetGateways()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysResponse> {
        /**
         * <p>
         * Information about the egress-only Internet gateways.
         * </p>
         * 
         * @param egressOnlyInternetGateways
         *        Information about the egress-only Internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGateways(Collection<EgressOnlyInternetGateway> egressOnlyInternetGateways);

        /**
         * <p>
         * Information about the egress-only Internet gateways.
         * </p>
         * 
         * @param egressOnlyInternetGateways
         *        Information about the egress-only Internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGateways(EgressOnlyInternetGateway... egressOnlyInternetGateways);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<EgressOnlyInternetGateway> egressOnlyInternetGateways;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEgressOnlyInternetGatewaysResponse model) {
            egressOnlyInternetGateways(model.egressOnlyInternetGateways);
            nextToken(model.nextToken);
        }

        public final Collection<EgressOnlyInternetGateway.Builder> getEgressOnlyInternetGateways() {
            return egressOnlyInternetGateways != null ? egressOnlyInternetGateways.stream()
                    .map(EgressOnlyInternetGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder egressOnlyInternetGateways(Collection<EgressOnlyInternetGateway> egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways = EgressOnlyInternetGatewayListCopier.copy(egressOnlyInternetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGateways(EgressOnlyInternetGateway... egressOnlyInternetGateways) {
            egressOnlyInternetGateways(Arrays.asList(egressOnlyInternetGateways));
            return this;
        }

        public final void setEgressOnlyInternetGateways(
                Collection<EgressOnlyInternetGateway.BuilderImpl> egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways = EgressOnlyInternetGatewayListCopier.copyFromBuilder(egressOnlyInternetGateways);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEgressOnlyInternetGatewaysResponse build() {
            return new DescribeEgressOnlyInternetGatewaysResponse(this);
        }
    }
}
