/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeConversionTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConversionTasksRequest extends EC2Request implements
        ToCopyableBuilder<DescribeConversionTasksRequest.Builder, DescribeConversionTasksRequest> {
    private final List<String> conversionTaskIds;

    private DescribeConversionTasksRequest(BuilderImpl builder) {
        super(builder);
        this.conversionTaskIds = builder.conversionTaskIds;
    }

    /**
     * <p>
     * One or more conversion task IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more conversion task IDs.
     */
    public List<String> conversionTaskIds() {
        return conversionTaskIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversionTaskIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConversionTasksRequest)) {
            return false;
        }
        DescribeConversionTasksRequest other = (DescribeConversionTasksRequest) obj;
        return Objects.equals(conversionTaskIds(), other.conversionTaskIds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (conversionTaskIds() != null) {
            sb.append("ConversionTaskIds: ").append(conversionTaskIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConversionTaskIds":
            return Optional.of(clazz.cast(conversionTaskIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeConversionTasksRequest> {
        /**
         * <p>
         * One or more conversion task IDs.
         * </p>
         * 
         * @param conversionTaskIds
         *        One or more conversion task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTaskIds(Collection<String> conversionTaskIds);

        /**
         * <p>
         * One or more conversion task IDs.
         * </p>
         * 
         * @param conversionTaskIds
         *        One or more conversion task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTaskIds(String... conversionTaskIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> conversionTaskIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConversionTasksRequest model) {
            conversionTaskIds(model.conversionTaskIds);
        }

        public final Collection<String> getConversionTaskIds() {
            return conversionTaskIds;
        }

        @Override
        public final Builder conversionTaskIds(Collection<String> conversionTaskIds) {
            this.conversionTaskIds = ConversionIdStringListCopier.copy(conversionTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTaskIds(String... conversionTaskIds) {
            conversionTaskIds(Arrays.asList(conversionTaskIds));
            return this;
        }

        public final void setConversionTaskIds(Collection<String> conversionTaskIds) {
            this.conversionTaskIds = ConversionIdStringListCopier.copy(conversionTaskIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeConversionTasksRequest build() {
            return new DescribeConversionTasksRequest(this);
        }
    }
}
