/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeAccountAttributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAccountAttributesResponse extends EC2Response implements
        ToCopyableBuilder<DescribeAccountAttributesResponse.Builder, DescribeAccountAttributesResponse> {
    private final List<AccountAttribute> accountAttributes;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.accountAttributes = builder.accountAttributes;
    }

    /**
     * <p>
     * Information about one or more account attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more account attributes.
     */
    public List<AccountAttribute> accountAttributes() {
        return accountAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse) obj;
        return Objects.equals(accountAttributes(), other.accountAttributes());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accountAttributes() != null) {
            sb.append("AccountAttributes: ").append(accountAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAttributes":
            return Optional.of(clazz.cast(accountAttributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        /**
         * <p>
         * Information about one or more account attributes.
         * </p>
         * 
         * @param accountAttributes
         *        Information about one or more account attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAttributes(Collection<AccountAttribute> accountAttributes);

        /**
         * <p>
         * Information about one or more account attributes.
         * </p>
         * 
         * @param accountAttributes
         *        Information about one or more account attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAttributes(AccountAttribute... accountAttributes);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<AccountAttribute> accountAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            accountAttributes(model.accountAttributes);
        }

        public final Collection<AccountAttribute.Builder> getAccountAttributes() {
            return accountAttributes != null ? accountAttributes.stream().map(AccountAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAttributes(Collection<AccountAttribute> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copy(accountAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(AccountAttribute... accountAttributes) {
            accountAttributes(Arrays.asList(accountAttributes));
            return this;
        }

        public final void setAccountAttributes(Collection<AccountAttribute.BuilderImpl> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copyFromBuilder(accountAttributes);
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }
    }
}
