/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteFlowLogs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteFlowLogsRequest extends EC2Request implements
        ToCopyableBuilder<DeleteFlowLogsRequest.Builder, DeleteFlowLogsRequest> {
    private final List<String> flowLogIds;

    private DeleteFlowLogsRequest(BuilderImpl builder) {
        super(builder);
        this.flowLogIds = builder.flowLogIds;
    }

    /**
     * <p>
     * One or more flow log IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more flow log IDs.
     */
    public List<String> flowLogIds() {
        return flowLogIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowLogIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowLogsRequest)) {
            return false;
        }
        DeleteFlowLogsRequest other = (DeleteFlowLogsRequest) obj;
        return Objects.equals(flowLogIds(), other.flowLogIds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (flowLogIds() != null) {
            sb.append("FlowLogIds: ").append(flowLogIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowLogIds":
            return Optional.of(clazz.cast(flowLogIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DeleteFlowLogsRequest> {
        /**
         * <p>
         * One or more flow log IDs.
         * </p>
         * 
         * @param flowLogIds
         *        One or more flow log IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(Collection<String> flowLogIds);

        /**
         * <p>
         * One or more flow log IDs.
         * </p>
         * 
         * @param flowLogIds
         *        One or more flow log IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(String... flowLogIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> flowLogIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowLogsRequest model) {
            flowLogIds(model.flowLogIds);
        }

        public final Collection<String> getFlowLogIds() {
            return flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String... flowLogIds) {
            flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteFlowLogsRequest build() {
            return new DeleteFlowLogsRequest(this);
        }
    }
}
