/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateTags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTagsRequest extends EC2Request implements ToCopyableBuilder<CreateTagsRequest.Builder, CreateTagsRequest> {
    private final List<String> resources;

    private final List<Tag> tags;

    private CreateTagsRequest(BuilderImpl builder) {
        super(builder);
        this.resources = builder.resources;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The IDs of one or more resources to tag. For example, ami-1a2b3c4d.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more resources to tag. For example, ami-1a2b3c4d.
     */
    public List<String> resources() {
        return resources;
    }

    /**
     * <p>
     * One or more tags. The <code>value</code> parameter is required, but if you don't want the tag to have a value,
     * specify the parameter with no value, and we set the value to an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more tags. The <code>value</code> parameter is required, but if you don't want the tag to have a
     *         value, specify the parameter with no value, and we set the value to an empty string.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTagsRequest)) {
            return false;
        }
        CreateTagsRequest other = (CreateTagsRequest) obj;
        return Objects.equals(resources(), other.resources()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resources() != null) {
            sb.append("Resources: ").append(resources()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resources":
            return Optional.of(clazz.cast(resources()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateTagsRequest> {
        /**
         * <p>
         * The IDs of one or more resources to tag. For example, ami-1a2b3c4d.
         * </p>
         * 
         * @param resources
         *        The IDs of one or more resources to tag. For example, ami-1a2b3c4d.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * The IDs of one or more resources to tag. For example, ami-1a2b3c4d.
         * </p>
         * 
         * @param resources
         *        The IDs of one or more resources to tag. For example, ami-1a2b3c4d.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);

        /**
         * <p>
         * One or more tags. The <code>value</code> parameter is required, but if you don't want the tag to have a
         * value, specify the parameter with no value, and we set the value to an empty string.
         * </p>
         * 
         * @param tags
         *        One or more tags. The <code>value</code> parameter is required, but if you don't want the tag to have
         *        a value, specify the parameter with no value, and we set the value to an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags. The <code>value</code> parameter is required, but if you don't want the tag to have a
         * value, specify the parameter with no value, and we set the value to an empty string.
         * </p>
         * 
         * @param tags
         *        One or more tags. The <code>value</code> parameter is required, but if you don't want the tag to have
         *        a value, specify the parameter with no value, and we set the value to an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> resources;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTagsRequest model) {
            resources(model.resources);
            tags(model.tags);
        }

        public final Collection<String> getResources() {
            return resources;
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = ResourceIdListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourceIdListCopier.copy(resources);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateTagsRequest build() {
            return new CreateTagsRequest(this);
        }
    }
}
