/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateRouteTable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateRouteTableResponse extends EC2Response implements
        ToCopyableBuilder<CreateRouteTableResponse.Builder, CreateRouteTableResponse> {
    private final RouteTable routeTable;

    private CreateRouteTableResponse(BuilderImpl builder) {
        super(builder);
        this.routeTable = builder.routeTable;
    }

    /**
     * <p>
     * Information about the route table.
     * </p>
     * 
     * @return Information about the route table.
     */
    public RouteTable routeTable() {
        return routeTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(routeTable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteTableResponse)) {
            return false;
        }
        CreateRouteTableResponse other = (CreateRouteTableResponse) obj;
        return Objects.equals(routeTable(), other.routeTable());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (routeTable() != null) {
            sb.append("RouteTable: ").append(routeTable()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteTable":
            return Optional.of(clazz.cast(routeTable()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateRouteTableResponse> {
        /**
         * <p>
         * Information about the route table.
         * </p>
         * 
         * @param routeTable
         *        Information about the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTable(RouteTable routeTable);

        /**
         * <p>
         * Information about the route table.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteTable.Builder} avoiding the need to create
         * one manually via {@link RouteTable#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteTable.Builder#build()} is called immediately and its result
         * is passed to {@link #routeTable(RouteTable)}.
         * 
         * @param routeTable
         *        a consumer that will call methods on {@link RouteTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTable(RouteTable)
         */
        default Builder routeTable(Consumer<RouteTable.Builder> routeTable) {
            return routeTable(RouteTable.builder().apply(routeTable).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private RouteTable routeTable;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteTableResponse model) {
            routeTable(model.routeTable);
        }

        public final RouteTable.Builder getRouteTable() {
            return routeTable != null ? routeTable.toBuilder() : null;
        }

        @Override
        public final Builder routeTable(RouteTable routeTable) {
            this.routeTable = routeTable;
            return this;
        }

        public final void setRouteTable(RouteTable.BuilderImpl routeTable) {
            this.routeTable = routeTable != null ? routeTable.build() : null;
        }

        @Override
        public CreateRouteTableResponse build() {
            return new CreateRouteTableResponse(this);
        }
    }
}
