/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateFlowLogs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateFlowLogsResponse extends EC2Response implements
        ToCopyableBuilder<CreateFlowLogsResponse.Builder, CreateFlowLogsResponse> {
    private final String clientToken;

    private final List<String> flowLogIds;

    private final List<UnsuccessfulItem> unsuccessful;

    private CreateFlowLogsResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.flowLogIds = builder.flowLogIds;
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The IDs of the flow logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the flow logs.
     */
    public List<String> flowLogIds() {
        return flowLogIds;
    }

    /**
     * <p>
     * Information about the flow logs that could not be created successfully.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the flow logs that could not be created successfully.
     */
    public List<UnsuccessfulItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogIds());
        hashCode = 31 * hashCode + Objects.hashCode(unsuccessful());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsResponse)) {
            return false;
        }
        CreateFlowLogsResponse other = (CreateFlowLogsResponse) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(flowLogIds(), other.flowLogIds())
                && Objects.equals(unsuccessful(), other.unsuccessful());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (flowLogIds() != null) {
            sb.append("FlowLogIds: ").append(flowLogIds()).append(",");
        }
        if (unsuccessful() != null) {
            sb.append("Unsuccessful: ").append(unsuccessful()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "FlowLogIds":
            return Optional.of(clazz.cast(flowLogIds()));
        case "Unsuccessful":
            return Optional.of(clazz.cast(unsuccessful()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateFlowLogsResponse> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The IDs of the flow logs.
         * </p>
         * 
         * @param flowLogIds
         *        The IDs of the flow logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(Collection<String> flowLogIds);

        /**
         * <p>
         * The IDs of the flow logs.
         * </p>
         * 
         * @param flowLogIds
         *        The IDs of the flow logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(String... flowLogIds);

        /**
         * <p>
         * Information about the flow logs that could not be created successfully.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the flow logs that could not be created successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful);

        /**
         * <p>
         * Information about the flow logs that could not be created successfully.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the flow logs that could not be created successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(UnsuccessfulItem... unsuccessful);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String clientToken;

        private List<String> flowLogIds;

        private List<UnsuccessfulItem> unsuccessful;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowLogsResponse model) {
            clientToken(model.clientToken);
            flowLogIds(model.flowLogIds);
            unsuccessful(model.unsuccessful);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<String> getFlowLogIds() {
            return flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String... flowLogIds) {
            flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        public final Collection<UnsuccessfulItem.Builder> getUnsuccessful() {
            return unsuccessful != null ? unsuccessful.stream().map(UnsuccessfulItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public CreateFlowLogsResponse build() {
            return new CreateFlowLogsResponse(this);
        }
    }
}
