/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AttachClassicLinkVpc.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachClassicLinkVpcRequest extends EC2Request implements
        ToCopyableBuilder<AttachClassicLinkVpcRequest.Builder, AttachClassicLinkVpcRequest> {
    private final List<String> groups;

    private final String instanceId;

    private final String vpcId;

    private AttachClassicLinkVpcRequest(BuilderImpl builder) {
        super(builder);
        this.groups = builder.groups;
        this.instanceId = builder.instanceId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ID of one or more of the VPC's security groups. You cannot specify security groups from a different
     *         VPC.
     */
    public List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.
     * </p>
     * 
     * @return The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of a ClassicLink-enabled VPC.
     * </p>
     * 
     * @return The ID of a ClassicLink-enabled VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachClassicLinkVpcRequest)) {
            return false;
        }
        AttachClassicLinkVpcRequest other = (AttachClassicLinkVpcRequest) obj;
        return Objects.equals(groups(), other.groups()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groups() != null) {
            sb.append("Groups: ").append(groups()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.of(clazz.cast(groups()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, AttachClassicLinkVpcRequest> {
        /**
         * <p>
         * The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.
         * </p>
         * 
         * @param groups
         *        The ID of one or more of the VPC's security groups. You cannot specify security groups from a
         *        different VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.
         * </p>
         * 
         * @param groups
         *        The ID of one or more of the VPC's security groups. You cannot specify security groups from a
         *        different VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.
         * </p>
         * 
         * @param instanceId
         *        The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of a ClassicLink-enabled VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of a ClassicLink-enabled VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> groups;

        private String instanceId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachClassicLinkVpcRequest model) {
            groups(model.groups);
            instanceId(model.instanceId);
            vpcId(model.vpcId);
        }

        public final Collection<String> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AttachClassicLinkVpcRequest build() {
            return new AttachClassicLinkVpcRequest(this);
        }
    }
}
