/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AssignIpv6AddressesResponse extends EC2Response implements
        ToCopyableBuilder<AssignIpv6AddressesResponse.Builder, AssignIpv6AddressesResponse> {
    private final List<String> assignedIpv6Addresses;

    private final String networkInterfaceId;

    private AssignIpv6AddressesResponse(BuilderImpl builder) {
        super(builder);
        this.assignedIpv6Addresses = builder.assignedIpv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    /**
     * <p>
     * The IPv6 addresses assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IPv6 addresses assigned to the network interface.
     */
    public List<String> assignedIpv6Addresses() {
        return assignedIpv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assignedIpv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesResponse)) {
            return false;
        }
        AssignIpv6AddressesResponse other = (AssignIpv6AddressesResponse) obj;
        return Objects.equals(assignedIpv6Addresses(), other.assignedIpv6Addresses())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (assignedIpv6Addresses() != null) {
            sb.append("AssignedIpv6Addresses: ").append(assignedIpv6Addresses()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignedIpv6Addresses":
            return Optional.of(clazz.cast(assignedIpv6Addresses()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, AssignIpv6AddressesResponse> {
        /**
         * <p>
         * The IPv6 addresses assigned to the network interface.
         * </p>
         * 
         * @param assignedIpv6Addresses
         *        The IPv6 addresses assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv6Addresses(Collection<String> assignedIpv6Addresses);

        /**
         * <p>
         * The IPv6 addresses assigned to the network interface.
         * </p>
         * 
         * @param assignedIpv6Addresses
         *        The IPv6 addresses assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv6Addresses(String... assignedIpv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<String> assignedIpv6Addresses;

        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesResponse model) {
            assignedIpv6Addresses(model.assignedIpv6Addresses);
            networkInterfaceId(model.networkInterfaceId);
        }

        public final Collection<String> getAssignedIpv6Addresses() {
            return assignedIpv6Addresses;
        }

        @Override
        public final Builder assignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv6Addresses(String... assignedIpv6Addresses) {
            assignedIpv6Addresses(Arrays.asList(assignedIpv6Addresses));
            return this;
        }

        public final void setAssignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public AssignIpv6AddressesResponse build() {
            return new AssignIpv6AddressesResponse(this);
        }
    }
}
