/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a running instance in a Spot fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ActiveInstance implements ToCopyableBuilder<ActiveInstance.Builder, ActiveInstance> {
    private final String instanceId;

    private final String instanceType;

    private final String spotInstanceRequestId;

    private final String instanceHealth;

    private ActiveInstance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.instanceHealth = builder.instanceHealth;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the Spot instance request.
     * </p>
     * 
     * @return The ID of the Spot instance request.
     */
    public String spotInstanceRequestId() {
        return spotInstanceRequestId;
    }

    /**
     * <p>
     * The health status of the instance. If the status of either the instance status check or the system status check
     * is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the health
     * status is <code>healthy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceHealth}
     * will return {@link InstanceHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceHealthString}.
     * </p>
     * 
     * @return The health status of the instance. If the status of either the instance status check or the system status
     *         check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise,
     *         the health status is <code>healthy</code>.
     * @see InstanceHealthStatus
     */
    public InstanceHealthStatus instanceHealth() {
        return InstanceHealthStatus.fromValue(instanceHealth);
    }

    /**
     * <p>
     * The health status of the instance. If the status of either the instance status check or the system status check
     * is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the health
     * status is <code>healthy</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceHealth}
     * will return {@link InstanceHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceHealthString}.
     * </p>
     * 
     * @return The health status of the instance. If the status of either the instance status check or the system status
     *         check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise,
     *         the health status is <code>healthy</code>.
     * @see InstanceHealthStatus
     */
    public String instanceHealthString() {
        return instanceHealth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceHealthString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveInstance)) {
            return false;
        }
        ActiveInstance other = (ActiveInstance) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(spotInstanceRequestId(), other.spotInstanceRequestId())
                && Objects.equals(instanceHealthString(), other.instanceHealthString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (spotInstanceRequestId() != null) {
            sb.append("SpotInstanceRequestId: ").append(spotInstanceRequestId()).append(",");
        }
        if (instanceHealthString() != null) {
            sb.append("InstanceHealth: ").append(instanceHealthString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "SpotInstanceRequestId":
            return Optional.of(clazz.cast(spotInstanceRequestId()));
        case "InstanceHealth":
            return Optional.of(clazz.cast(instanceHealthString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ActiveInstance> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the Spot instance request.
         * </p>
         * 
         * @param spotInstanceRequestId
         *        The ID of the Spot instance request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestId(String spotInstanceRequestId);

        /**
         * <p>
         * The health status of the instance. If the status of either the instance status check or the system status
         * check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the
         * health status is <code>healthy</code>.
         * </p>
         * 
         * @param instanceHealth
         *        The health status of the instance. If the status of either the instance status check or the system
         *        status check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>.
         *        Otherwise, the health status is <code>healthy</code>.
         * @see InstanceHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthStatus
         */
        Builder instanceHealth(String instanceHealth);

        /**
         * <p>
         * The health status of the instance. If the status of either the instance status check or the system status
         * check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the
         * health status is <code>healthy</code>.
         * </p>
         * 
         * @param instanceHealth
         *        The health status of the instance. If the status of either the instance status check or the system
         *        status check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>.
         *        Otherwise, the health status is <code>healthy</code>.
         * @see InstanceHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthStatus
         */
        Builder instanceHealth(InstanceHealthStatus instanceHealth);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String instanceType;

        private String spotInstanceRequestId;

        private String instanceHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveInstance model) {
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            spotInstanceRequestId(model.spotInstanceRequestId);
            instanceHealth(model.instanceHealth);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSpotInstanceRequestId() {
            return spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getInstanceHealth() {
            return instanceHealth;
        }

        @Override
        public final Builder instanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
            return this;
        }

        @Override
        public final Builder instanceHealth(InstanceHealthStatus instanceHealth) {
            this.instanceHealth(instanceHealth.toString());
            return this;
        }

        public final void setInstanceHealth(String instanceHealth) {
            this.instanceHealth = instanceHealth;
        }

        @Override
        public ActiveInstance build() {
            return new ActiveInstance(this);
        }
    }
}
