/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * VpnConnection StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VpnConnectionUnmarshaller implements Unmarshaller<VpnConnection, StaxUnmarshallerContext> {

    public VpnConnection unmarshall(StaxUnmarshallerContext context) throws Exception {
        VpnConnection.Builder vpnConnection = VpnConnection.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<VpnStaticRoute> routes = null;
        java.util.List<Tag> tags = null;
        java.util.List<VgwTelemetry> vgwTelemetry = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                vpnConnection.routes(routes);
                vpnConnection.tags(tags);
                vpnConnection.vgwTelemetry(vgwTelemetry);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("customerGatewayConfiguration", targetDepth)) {
                    vpnConnection.customerGatewayConfiguration(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("customerGatewayId", targetDepth)) {
                    vpnConnection.customerGatewayId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("category", targetDepth)) {
                    vpnConnection.category(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    vpnConnection.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("type", targetDepth)) {
                    vpnConnection.type(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpnConnectionId", targetDepth)) {
                    vpnConnection.vpnConnectionId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpnGatewayId", targetDepth)) {
                    vpnConnection.vpnGatewayId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("options", targetDepth)) {
                    vpnConnection.options(VpnConnectionOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("routes", targetDepth)) {
                    routes = new ArrayList<VpnStaticRoute>();
                    continue;
                }

                if (context.testExpression("routes/item", targetDepth)) {
                    routes.add(VpnStaticRouteUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vgwTelemetry", targetDepth)) {
                    vgwTelemetry = new ArrayList<VgwTelemetry>();
                    continue;
                }

                if (context.testExpression("vgwTelemetry/item", targetDepth)) {
                    vgwTelemetry.add(VgwTelemetryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    vpnConnection.routes(routes);
                    vpnConnection.tags(tags);
                    vpnConnection.vgwTelemetry(vgwTelemetry);
                    break;
                }
            }
        }
        return vpnConnection.build();
    }

    private static final VpnConnectionUnmarshaller INSTANCE = new VpnConnectionUnmarshaller();

    public static VpnConnectionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
