/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ServiceDetail StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ServiceDetailUnmarshaller implements Unmarshaller<ServiceDetail, StaxUnmarshallerContext> {

    public ServiceDetail unmarshall(StaxUnmarshallerContext context) throws Exception {
        ServiceDetail.Builder serviceDetail = ServiceDetail.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ServiceTypeDetail> serviceType = null;
        java.util.List<String> availabilityZones = null;
        java.util.List<String> baseEndpointDnsNames = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                serviceDetail.serviceType(serviceType);
                serviceDetail.availabilityZones(availabilityZones);
                serviceDetail.baseEndpointDnsNames(baseEndpointDnsNames);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("serviceName", targetDepth)) {
                    serviceDetail.serviceName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("serviceType", targetDepth)) {
                    serviceType = new ArrayList<ServiceTypeDetail>();
                    continue;
                }

                if (context.testExpression("serviceType/item", targetDepth)) {
                    serviceType.add(ServiceTypeDetailUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("availabilityZoneSet", targetDepth)) {
                    availabilityZones = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("availabilityZoneSet/item", targetDepth)) {
                    availabilityZones.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("owner", targetDepth)) {
                    serviceDetail.owner(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("baseEndpointDnsNameSet", targetDepth)) {
                    baseEndpointDnsNames = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("baseEndpointDnsNameSet/item", targetDepth)) {
                    baseEndpointDnsNames.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateDnsName", targetDepth)) {
                    serviceDetail.privateDnsName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcEndpointPolicySupported", targetDepth)) {
                    serviceDetail.vpcEndpointPolicySupported(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("acceptanceRequired", targetDepth)) {
                    serviceDetail.acceptanceRequired(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    serviceDetail.serviceType(serviceType);
                    serviceDetail.availabilityZones(availabilityZones);
                    serviceDetail.baseEndpointDnsNames(baseEndpointDnsNames);
                    break;
                }
            }
        }
        return serviceDetail.build();
    }

    private static final ServiceDetailUnmarshaller INSTANCE = new ServiceDetailUnmarshaller();

    public static ServiceDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}
